/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.mc.event.DisplayResizeEvent;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_9779;

public abstract class ContainerOverlay<T extends Overlay>
extends Overlay {
    private static final int DEFAULT_SPACING = 3;
    @Persisted(i18nKey="overlay.wynntils.overlay.growDirection")
    private final Config<GrowDirection> growDirection = new Config<GrowDirection>(GrowDirection.DOWN);
    @Persisted(i18nKey="overlay.wynntils.overlay.spacing")
    private final Config<Integer> spacing = new Config<Integer>(3);
    private final List<T> children = new ArrayList<T>();
    private final Map<T, OverlaySize> inherentSize = new HashMap<T, OverlaySize>();

    private ContainerOverlay(OverlayPosition position, OverlaySize size, GrowDirection growDirection, int spacing, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        super(position, size);
        this.growDirection.store(growDirection);
        this.spacing.store(spacing);
        this.horizontalAlignmentOverride.store(horizontalAlignment);
        this.verticalAlignmentOverride.store(verticalAlignment);
        WynntilsMod.registerListener(this::onResizeEvent);
    }

    protected ContainerOverlay(OverlayPosition position, OverlaySize size, GrowDirection growDirection, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this(position, size, growDirection, 3, horizontalAlignment, verticalAlignment);
    }

    public void addChild(T overlay) {
        this.inherentSize.put(overlay, ((Overlay)overlay).getSize().copy());
        this.children.add(overlay);
        WynntilsMod.registerEventListener(overlay);
        this.updateAllChildren();
    }

    public void clearChildren() {
        this.children.forEach(WynntilsMod::unregisterEventListener);
        this.children.clear();
        this.inherentSize.clear();
    }

    public int size() {
        return this.children.size();
    }

    protected abstract List<T> getPreviewChildren();

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        this.children.forEach(o -> o.render(guiGraphics, bufferSource, deltaTracker, window));
    }

    @Override
    public void renderPreview(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        List<Overlay> previewChildren = this.getPreviewChildren();
        Map previewSize = previewChildren.stream().collect(Collectors.toMap(Function.identity(), Overlay::getSize));
        this.updateLayout(previewChildren, previewSize);
        previewChildren.forEach(o -> o.renderPreview(guiGraphics, bufferSource, deltaTracker, window));
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.updateAllChildren();
    }

    @Override
    public void setPosition(OverlayPosition position) {
        super.setPosition(position);
        this.updateAllChildren();
    }

    @Override
    public void setHeight(float height) {
        super.setHeight(height);
        this.updateAllChildren();
    }

    @Override
    public void setWidth(float width) {
        super.setWidth(width);
        this.updateAllChildren();
    }

    private void onResizeEvent(DisplayResizeEvent event) {
        this.updateAllChildren();
    }

    private void updateAllChildren() {
        this.updateLayout(this.children, this.inherentSize);
    }

    private void updateLayout(List<T> children, Map<T, OverlaySize> inherentSize) {
        int currentHeight = 0;
        int currentWidth = 0;
        GrowDirection direction = (GrowDirection)((Object)this.growDirection.get());
        for (Overlay overlay : children) {
            overlay.setPosition(direction.getChildPosition(this.getRenderX(), this.getRenderY(), this.getSize(), overlay.getSize(), currentWidth, currentHeight));
            direction.updateSize(overlay, this.getSize(), inherentSize.get(overlay));
            overlay.horizontalAlignmentOverride.store((HorizontalAlignment)this.horizontalAlignmentOverride.get());
            overlay.verticalAlignmentOverride.store((VerticalAlignment)this.verticalAlignmentOverride.get());
            currentHeight = (int)((float)currentHeight + (overlay.getSize().getHeight() + (float)((Integer)this.spacing.get()).intValue()));
            currentWidth = (int)((float)currentWidth + (overlay.getSize().getWidth() + (float)((Integer)this.spacing.get()).intValue()));
        }
    }

    public static enum GrowDirection {
        UP(-1, 0),
        DOWN(1, 0),
        LEFT(0, -1),
        RIGHT(0, 1);

        private final int verticalMultiplier;
        private final int horizontalMultiplier;

        private GrowDirection(int verticalMultiplier, int horizontalMultiplier) {
            this.verticalMultiplier = verticalMultiplier;
            this.horizontalMultiplier = horizontalMultiplier;
        }

        private void updateSize(Overlay overlay, OverlaySize containerSize, OverlaySize inherentSize) {
            OverlaySize size = overlay.getSize();
            if (this.verticalMultiplier != 0) {
                size.setWidth(containerSize.getWidth());
                size.setHeight(inherentSize.getHeight());
            }
            if (this.horizontalMultiplier != 0) {
                size.setWidth(inherentSize.getWidth());
                size.setHeight(containerSize.getHeight());
            }
        }

        private OverlayPosition getChildPosition(float containerX, float containerY, OverlaySize containerSize, OverlaySize childSize, int accumulatedWidth, int accumulatedHeight) {
            float heightOffset = this.verticalMultiplier < 0 ? containerSize.getHeight() - childSize.getHeight() : 0.0f;
            float widthOffset = this.horizontalMultiplier < 0 ? containerSize.getWidth() - childSize.getWidth() : 0.0f;
            return new OverlayPosition(containerY + heightOffset + (float)(accumulatedHeight * this.verticalMultiplier), containerX + widthOffset + (float)(accumulatedWidth * this.horizontalMultiplier), VerticalAlignment.TOP, HorizontalAlignment.LEFT, OverlayPosition.AnchorSection.TOP_LEFT);
        }
    }
}

