/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.DynamicOverlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_1041;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_9779;

public abstract class TextOverlay
extends DynamicOverlay {
    @Persisted(i18nKey="overlay.wynntils.textOverlay.textShadow")
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted(i18nKey="overlay.wynntils.textOverlay.fontScale")
    protected final Config<Float> fontScale = new Config<Float>(Float.valueOf(1.0f));
    private StyledText[] cachedLines = new StyledText[0];

    protected TextOverlay(OverlayPosition position, float width, float height) {
        super(position, width, height, 1);
    }

    protected TextOverlay(OverlayPosition position, OverlaySize size) {
        super(position, size, 1);
    }

    protected TextOverlay(OverlayPosition position, OverlaySize size, HorizontalAlignment horizontalAlignmentOverride, VerticalAlignment verticalAlignmentOverride) {
        super(position, size, horizontalAlignmentOverride, verticalAlignmentOverride, 1);
    }

    protected TextOverlay(OverlayPosition position, OverlaySize size, HorizontalAlignment horizontalAlignmentOverride, VerticalAlignment verticalAlignmentOverride, int id) {
        super(position, size, horizontalAlignmentOverride, verticalAlignmentOverride, id);
    }

    protected TextOverlay(int id) {
        super(id);
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        this.renderTemplate(guiGraphics, bufferSource, this.cachedLines, this.getTextScale());
    }

    @Override
    public void renderPreview(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        this.renderTemplate(guiGraphics, bufferSource, this.calculateTemplateValue(this.getPreviewTemplate()), this.getTextScale());
    }

    private void renderTemplate(class_332 guiGraphics, class_4597 bufferSource, StyledText[] lines, float textScale) {
        float renderX = this.getRenderX();
        float renderY = this.getRenderY();
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), bufferSource, lines, renderX, renderX + this.getWidth(), renderY, renderY + this.getHeight(), 0.0f, this.getRenderColor(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment(), (TextShadow)this.textShadow.get(), textScale);
    }

    @Override
    public void tick() {
        if (!this.isRendered()) {
            return;
        }
        this.cachedLines = this.calculateTemplateValue(this.getTemplate());
    }

    @Override
    protected boolean isVisible() {
        return !this.getTemplate().isEmpty();
    }

    protected StyledText[] calculateTemplateValue(String template) {
        return Managers.Function.doFormatLines(template);
    }

    protected CustomColor getRenderColor() {
        return CommonColors.WHITE;
    }

    private float getTextScale() {
        return ((Float)this.fontScale.get()).floatValue();
    }

    protected abstract String getTemplate();

    protected abstract String getPreviewTemplate();
}

