/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.net;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.net.QueuedDownload;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class DownloadDependencyGraph {
    private final Map<Node, NodeState> nodeMap = new ConcurrentHashMap<Node, NodeState>();

    private DownloadDependencyGraph(List<Node> nodes) {
        nodes.forEach(node -> this.nodeMap.put((Node)node, node.dependencies.isEmpty() ? NodeState.QUEUED : NodeState.WAITING_ON_DEPENDENCY));
    }

    public static DownloadDependencyGraph build(List<QueuedDownload> downloads) {
        if (downloads.isEmpty()) {
            return new DownloadDependencyGraph(List.of());
        }
        DownloadDependencyGraph.checkDuplicateDownloads(downloads);
        DownloadDependencyGraph.checkMissingDependencies(downloads);
        List<Node> nodes = downloads.stream().map(Node::new).toList();
        nodes.forEach(node -> node.calculateDependencies(nodes));
        DownloadDependencyGraph.checkCircularDependencies(nodes);
        return new DownloadDependencyGraph(nodes);
    }

    public synchronized QueuedDownload nextDownload() {
        Node nextNode = this.nodeMap.entrySet().stream().filter(entry -> entry.getValue() == NodeState.QUEUED).map(Map.Entry::getKey).findAny().orElse(null);
        if (nextNode == null) {
            return null;
        }
        this.nodeMap.put(nextNode, NodeState.IN_PROGRESS);
        return nextNode.download;
    }

    public void markDownloadCompleted(QueuedDownload download) {
        Node node = this.nodeMap.keySet().stream().filter(n -> n.download == download).findAny().orElseThrow(() -> new IllegalStateException("Download not found in graph: " + String.valueOf((Object)download.urlId())));
        this.nodeMap.put(node, NodeState.COMPLETED);
        node.dependents.forEach(dependent -> {
            if (dependent.dependencies.stream().allMatch(dependency -> this.nodeMap.get(dependency) == NodeState.COMPLETED)) {
                this.nodeMap.put((Node)dependent, NodeState.QUEUED);
            }
        });
    }

    public void markDownloadError(QueuedDownload download) {
        Node node = this.nodeMap.keySet().stream().filter(n -> n.download == download).findAny().orElseThrow(() -> new IllegalStateException("Download not found in graph: " + String.valueOf((Object)download.urlId())));
        this.nodeMap.put(node, NodeState.ERROR);
        node.dependents.forEach(dependent -> this.nodeMap.put((Node)dependent, NodeState.ERROR));
    }

    public void markDownloadRetry(QueuedDownload download) {
        Node node = this.nodeMap.keySet().stream().filter(n -> n.download == download).findAny().orElseThrow(() -> new IllegalStateException("Download not found in graph: " + String.valueOf((Object)download.urlId())));
        node.dependents.forEach(dependent -> this.nodeMap.put((Node)dependent, NodeState.WAITING_ON_DEPENDENCY));
        LinkedList<Node> stack = new LinkedList<Node>();
        stack.addFirst(node);
        while (!stack.isEmpty()) {
            Node currentNode = (Node)stack.pop();
            if (currentNode.dependencies.isEmpty()) {
                this.nodeMap.put(currentNode, NodeState.QUEUED);
                continue;
            }
            this.nodeMap.put(currentNode, NodeState.WAITING_ON_DEPENDENCY);
            currentNode.dependencies.forEach(stack::addFirst);
        }
        this.nodeMap.put(node, node.dependencies.isEmpty() ? NodeState.QUEUED : NodeState.WAITING_ON_DEPENDENCY);
    }

    public void resetState() {
        this.nodeMap.replaceAll((node, state) -> node.dependencies.isEmpty() ? NodeState.QUEUED : NodeState.WAITING_ON_DEPENDENCY);
    }

    public DownloadDependencyGraphState state() {
        return new DownloadDependencyGraphState(this.isFinished(), this.hasError(), this.totalDownloads(), this.successfulDownloads(), this.failedDownloads(), this.errorRate());
    }

    public boolean isFinished() {
        return this.nodeMap.values().stream().allMatch(state -> state == NodeState.COMPLETED || state == NodeState.ERROR);
    }

    public boolean hasError() {
        return this.nodeMap.values().stream().anyMatch(state -> state == NodeState.ERROR);
    }

    public int totalDownloads() {
        return this.nodeMap.size();
    }

    public int successfulDownloads() {
        return (int)this.nodeMap.values().stream().filter(state -> state == NodeState.COMPLETED).count();
    }

    public int failedDownloads() {
        return (int)this.nodeMap.values().stream().filter(state -> state == NodeState.ERROR).count();
    }

    public float errorRate() {
        return (float)this.failedDownloads() / (float)this.totalDownloads();
    }

    public NodeState getDownloadState(QueuedDownload download) {
        Node node = this.nodeMap.keySet().stream().filter(n -> n.download == download).findAny().orElseThrow(() -> new IllegalStateException("Download not found in graph: " + String.valueOf((Object)download.urlId())));
        return this.nodeMap.get(node);
    }

    private static void checkDuplicateDownloads(List<QueuedDownload> downloads) {
        QueuedDownload duplicatedInSameComponent = downloads.stream().filter(download -> downloads.stream().anyMatch(other -> download != other && download.equals(other))).findAny().orElse(null);
        if (duplicatedInSameComponent != null) {
            throw new IllegalStateException(String.valueOf(duplicatedInSameComponent.callerComponent()) + " downloaded the same data twice: " + String.valueOf((Object)duplicatedInSameComponent.urlId()));
        }
        List<QueuedDownload> duplicatedDownloadsInSeparateComponents = downloads.stream().filter(download -> downloads.stream().anyMatch(other -> download != other && download.urlId() == other.urlId())).toList();
        if (!duplicatedDownloadsInSeparateComponents.isEmpty()) {
            WynntilsMod.warn("Multiple components downloaded the same data: " + String.valueOf((Object)duplicatedDownloadsInSeparateComponents.getFirst().urlId()) + ". Components: " + StringUtils.join((Object[])new List[]{duplicatedDownloadsInSeparateComponents.stream().map(QueuedDownload::callerComponent).toList()}));
        }
    }

    private static void checkMissingDependencies(List<QueuedDownload> downloads) {
        Set allDependencies = downloads.stream().flatMap(download -> download.dependency().dependencies().stream()).collect(Collectors.toUnmodifiableSet());
        for (Pair dependency : allDependencies) {
            boolean missingDependency = downloads.stream().noneMatch(download -> download.callerComponent() == dependency.a() && download.urlId() == dependency.b());
            if (!missingDependency) continue;
            throw new IllegalStateException("Missing dependency: " + String.valueOf(dependency.b()) + " for " + String.valueOf(dependency.a()));
        }
    }

    private static void checkCircularDependencies(List<Node> nodes) {
        for (Node node : nodes) {
            LinkedList<Node> stack = new LinkedList<Node>();
            stack.addFirst(node);
            while (!stack.isEmpty()) {
                Node currentNode = (Node)stack.pop();
                boolean circularDependency = currentNode.dependencies.stream().anyMatch(dependencyNode -> dependencyNode.dependencies.contains(node));
                if (circularDependency) {
                    throw new IllegalStateException("Circular dependency detected on: " + String.valueOf((Object)node.download.urlId()) + ". Starting from: " + String.valueOf(node.download.callerComponent()));
                }
                stack.addAll(currentNode.dependencies);
            }
        }
    }

    void logGraph() {
        WynntilsMod.info("[DownloadManager] Download Dependency Graph:");
        Map urlIdsByComponent = this.nodeMap.keySet().stream().sorted(Comparator.comparing(n -> n.download.callerComponent().getJsonName())).collect(Collectors.groupingBy(node -> node.download.callerComponent(), Collectors.mapping(node -> node.download.urlId(), Collectors.toList())));
        urlIdsByComponent.forEach((component, urlIds) -> {
            WynntilsMod.info("| -- " + StringUtils.capitalize((String)component.getJsonName()));
            urlIds.forEach(urlId -> {
                Node node = this.nodeMap.keySet().stream().filter(n -> n.download.callerComponent() == component && n.download.urlId() == urlId).findAny().orElseThrow();
                if (node.dependencies.isEmpty()) {
                    WynntilsMod.info("|    - " + String.valueOf(urlId));
                } else {
                    WynntilsMod.info("|    - " + String.valueOf(urlId) + " <- " + String.valueOf(node.dependencies.stream().map(dependency -> dependency.download.urlId()).toList()));
                }
            });
        });
    }

    private static final class Node {
        private final QueuedDownload download;
        private List<Node> dependencies = List.of();
        private List<Node> dependents = List.of();

        private Node(QueuedDownload download) {
            this.download = download;
        }

        private void calculateDependencies(List<Node> nodes) {
            ArrayList<Node> dependencies = new ArrayList<Node>();
            ArrayList<Node> dependents = new ArrayList<Node>();
            for (Node node : nodes) {
                if (this.download.dependency().dependsOn(node.download.callerComponent(), node.download.urlId())) {
                    dependencies.add(node);
                    continue;
                }
                if (!node.download.dependency().dependsOn(this.download.callerComponent(), this.download.urlId())) continue;
                dependents.add(node);
            }
            this.dependencies = List.copyOf(dependencies);
            this.dependents = List.copyOf(dependents);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.download, node.download);
        }

        public int hashCode() {
            return Objects.hashCode(this.download);
        }
    }

    public static enum NodeState {
        WAITING_ON_DEPENDENCY,
        QUEUED,
        IN_PROGRESS,
        COMPLETED,
        ERROR;

    }

    public record DownloadDependencyGraphState(boolean finished, boolean error, int totalDownloads, int successfulDownloads, int failedDownloads, float errorRate) {
        public boolean successful() {
            return !this.error && this.finished;
        }
    }
}

