/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.util.UndashedUuid;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.mod.event.WynncraftConnectionEvent;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.persisted.storage.Storageable;
import com.wynntils.core.persisted.upfixers.UpfixerType;
import com.wynntils.utils.mc.McUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class StorageManager
extends Manager {
    private static final long SAVE_INTERVAL = 10000L;
    private static final File STORAGE_DIR = WynntilsMod.getModStorageDir("storage");
    private static final String FILE_SUFFIX = ".data.json";
    private final File userStorageFile;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final Map<String, Storage<?>> storages = new TreeMap();
    private final Map<Storage<?>, Type> storageTypes = new HashMap();
    private final Map<Storage<?>, Storageable> storageOwner = new HashMap();
    private JsonObject storageObject;
    private long lastPersisted;
    private boolean scheduledPersist;
    private boolean storageInitialized = false;

    public StorageManager() {
        super(List.of());
        this.userStorageFile = new File(STORAGE_DIR, UndashedUuid.toString((UUID)McUtils.getUserProfileUUID()) + FILE_SUFFIX);
        this.addShutdownHook();
    }

    public void initComponents() {
        this.readFromJson();
    }

    public void initFeatures() {
        Managers.Feature.getFeatures().forEach(this::registerStorageable);
        this.runUpfixers();
        this.readFromJson();
        this.storageInitialized = true;
        this.persist();
    }

    public void registerStorageable(Storageable owner) {
        Managers.Persisted.verifyAnnotations(owner);
        Managers.Persisted.getPersisted(owner, Storage.class).forEach(p -> this.processStorage(owner, (Field)p.a(), (Persisted)p.b()));
    }

    public File getUserStorageFile() {
        return this.userStorageFile;
    }

    private void processStorage(Storageable owner, Field field, Persisted annotation) {
        try {
            String baseName = owner.getStorageJsonName();
            Storage storage = (Storage)FieldUtils.readField((Field)field, (Object)owner, (boolean)true);
            String jsonName = baseName + "." + field.getName();
            this.storages.put(jsonName, storage);
            Type valueType = Managers.Json.getJsonValueType(field);
            this.storageTypes.put(storage, valueType);
            this.storageOwner.put(storage, owner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::writeToJson));
    }

    @SubscribeEvent
    public void onWynncraftDisconnect(WynncraftConnectionEvent.Disconnected event) {
        this.writeToJson();
    }

    void persist() {
        if (!this.storageInitialized || this.scheduledPersist) {
            return;
        }
        long now = System.currentTimeMillis();
        long delay = Math.max(this.lastPersisted + 10000L - now, 0L);
        this.executor.schedule(() -> {
            this.scheduledPersist = false;
            this.lastPersisted = System.currentTimeMillis();
            this.writeToJson();
        }, delay, TimeUnit.MILLISECONDS);
        this.scheduledPersist = true;
    }

    private void runUpfixers() {
        this.storageObject = Managers.Json.loadPreciousJson(this.userStorageFile);
        HashSet workaround = new HashSet(this.storages.values());
        if (Managers.Upfixer.runUpfixers(this.storageObject, workaround, UpfixerType.STORAGE)) {
            Managers.Json.savePreciousJson(this.userStorageFile, this.storageObject);
        }
    }

    private void readFromJson() {
        this.storageObject = Managers.Json.loadPreciousJson(this.userStorageFile);
        this.storages.forEach((jsonName, storage) -> {
            if (!this.storageObject.has(jsonName)) {
                Storageable owner = this.storageOwner.get(storage);
                owner.onStorageLoad((Storage<?>)storage);
                return;
            }
            JsonElement jsonElem = this.storageObject.get(jsonName);
            Object value = JsonManager.GSON.fromJson(jsonElem, this.storageTypes.get(storage));
            Managers.Persisted.setRaw(storage, value);
            Storageable owner = this.storageOwner.get(storage);
            owner.onStorageLoad((Storage<?>)storage);
        });
    }

    private synchronized void writeToJson() {
        JsonObject storageJson = new JsonObject();
        String upfixerJsonMemberName = "wynntils.upfixers";
        storageJson.add(upfixerJsonMemberName, this.storageObject.get(upfixerJsonMemberName));
        this.storages.forEach((jsonName, storage) -> {
            try {
                JsonElement jsonElem = JsonManager.GSON.toJsonTree(storage.get(), this.storageTypes.get(storage));
                storageJson.add(jsonName, jsonElem);
            }
            catch (Throwable t) {
                WynntilsMod.error("Failed to save storage " + jsonName, t);
            }
        });
        Managers.Json.savePreciousJson(this.userStorageFile, storageJson);
    }
}

