/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.debug;

import com.google.gson.JsonElement;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.models.abilitytree.AbilityTreeModel;
import com.wynntils.models.abilitytree.type.AbilityTreeInfo;
import com.wynntils.models.items.items.gui.AbilityTreeItem;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import java.io.File;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.DEBUG)
public class AbilityTreeDataDumpFeature
extends Feature {
    private static final File SAVE_FOLDER = WynntilsMod.getModStorageDir("debug");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInventoryClick(ContainerClickEvent event) {
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof class_465)) {
            return;
        }
        class_465 abstractContainerScreen = (class_465)class_4372;
        if (!KeyboardUtils.isShiftDown()) {
            return;
        }
        Optional<AbilityTreeItem> abilityTreeItem = Models.Item.asWynnItem(event.getItemStack(), AbilityTreeItem.class);
        if (abilityTreeItem.isEmpty()) {
            return;
        }
        event.setCanceled(true);
        McUtils.player().method_7346();
        Managers.TickScheduler.scheduleNextTick(() -> AbilityTreeModel.ABILITY_TREE_CONTAINER_QUERIES.dumpAbilityTree(this::saveToDisk));
    }

    private void saveToDisk(AbilityTreeInfo abilityTreeInfo) {
        JsonElement element = JsonManager.GSON.toJsonTree((Object)abilityTreeInfo);
        String fileName = Models.Character.getClassType().getName().toLowerCase(Locale.ROOT) + "_abilities.json";
        File jsonFile = new File(SAVE_FOLDER, fileName);
        Managers.Json.savePreciousJson(jsonFile, element.getAsJsonObject());
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)("Saved ability tree dump to " + jsonFile.getAbsolutePath())));
    }
}

