/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.debug;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.models.items.WynnItem;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.RenderedStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.DEBUG)
public class ItemDebugTooltipsFeature
extends Feature {
    @SubscribeEvent
    public void onTooltipPre(ItemTooltipRenderEvent.Pre event) {
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(event.getItemStack());
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        WynnItem wynnItem = wynnItemOpt.get();
        List<class_2561> tooltips = LoreUtils.appendTooltip(event.getItemStack(), event.getTooltips(), this.getTooltipAddon(wynnItem));
        event.setTooltips(tooltips);
    }

    private List<class_2561> getTooltipAddon(WynnItem wynnItem) {
        ArrayList<class_2561> addon = new ArrayList<class_2561>();
        StyledText rawString = StyledText.fromUnformattedString(wynnItem.toString()).replaceAll("\u00a7", "%");
        List<StyledText> wrappedDescription = Arrays.stream(RenderedStringUtils.wrapTextBySize(rawString, 150)).toList();
        if (!KeyboardUtils.isKeyDown(344) && wrappedDescription.size() > 4) {
            wrappedDescription = new ArrayList<StyledText>(wrappedDescription.subList(0, 3));
            wrappedDescription.add(StyledText.fromString("..."));
            wrappedDescription.add(StyledText.fromString("Press Right Shift for all"));
        }
        for (StyledText line : wrappedDescription) {
            addon.add((class_2561)line.getComponent().method_27692(class_124.field_1077));
        }
        return addon;
    }
}

