/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.protocol.packets;

import com.wynntils.hades.protocol.interfaces.HadesPacket;
import com.wynntils.hades.protocol.packets.client.HCPacketAuthenticate;
import com.wynntils.hades.protocol.packets.client.HCPacketDiscordLobbyClient;
import com.wynntils.hades.protocol.packets.client.HCPacketPing;
import com.wynntils.hades.protocol.packets.client.HCPacketSocialUpdate;
import com.wynntils.hades.protocol.packets.client.HCPacketUpdateGuild;
import com.wynntils.hades.protocol.packets.client.HCPacketUpdateStatus;
import com.wynntils.hades.protocol.packets.client.HCPacketUpdateWorld;
import com.wynntils.hades.protocol.packets.server.HSPacketAuthenticationResponse;
import com.wynntils.hades.protocol.packets.server.HSPacketClearMutual;
import com.wynntils.hades.protocol.packets.server.HSPacketDisconnect;
import com.wynntils.hades.protocol.packets.server.HSPacketDiscordLobbyServer;
import com.wynntils.hades.protocol.packets.server.HSPacketPong;
import com.wynntils.hades.protocol.packets.server.HSPacketUpdateMutual;
import java.util.HashMap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PacketRegistry {
    SERVER{
        {
            this.registerPacket(HSPacketAuthenticationResponse.class);
            this.registerPacket(HSPacketDisconnect.class);
            this.registerPacket(HSPacketUpdateMutual.class);
            this.registerPacket(HSPacketDiscordLobbyServer.class);
            this.registerPacket(HSPacketClearMutual.class);
            this.registerPacket(HSPacketPong.class);
        }
    }
    ,
    CLIENT{
        {
            this.registerPacket(HCPacketAuthenticate.class);
            this.registerPacket(HCPacketSocialUpdate.class);
            this.registerPacket(HCPacketUpdateGuild.class);
            this.registerPacket(HCPacketUpdateStatus.class);
            this.registerPacket(HCPacketDiscordLobbyClient.class);
            this.registerPacket(HCPacketUpdateWorld.class);
            this.registerPacket(HCPacketPing.class);
        }
    };

    private final HashMap<Integer, Class<? extends HadesPacket>> registeredPackets = new HashMap();
    private final HashMap<Class<? extends HadesPacket>, Integer> reverseLookup = new HashMap();

    protected void registerPacket(Class<? extends HadesPacket<?>> packetClass) {
        if (this.registeredPackets.containsValue(packetClass)) {
            throw new IllegalArgumentException("Packet " + packetClass.getSimpleName() + " was registered twice!");
        }
        int id = this.registeredPackets.size();
        this.registeredPackets.put(id, packetClass);
        this.reverseLookup.put(packetClass, id);
    }

    public int getPacketId(Class<? extends HadesPacket> packet) {
        return this.reverseLookup.get(packet);
    }

    public HadesPacket<?> createPacket(int packetId) throws IllegalAccessException, InstantiationException {
        if (!this.registeredPackets.containsKey(packetId)) {
            return null;
        }
        return this.registeredPackets.get(packetId).newInstance();
    }
}

