/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatListDelimiter;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public final class TooltipIdentifications {
    public static List<class_2561> buildTooltip(IdentifiableItemProperty<?, ?> itemInfo, ClassType currentClass, TooltipIdentificationDecorator decorator, TooltipStyle style) {
        ArrayList<class_2561> identifications = new ArrayList<class_2561>();
        List<StatType> listOrdering = Models.Stat.getOrderingList(style.identificationOrdering());
        ArrayList<StatType> allStats = new ArrayList<StatType>(itemInfo.getVariableStats());
        itemInfo.getIdentifications().stream().map(StatActualValue::statType).filter(stat -> !allStats.contains(stat)).forEach(allStats::add);
        if (allStats.isEmpty()) {
            return identifications;
        }
        boolean useDelimiters = style.useDelimiters();
        boolean delimiterNeeded = false;
        for (StatType statType : listOrdering) {
            class_5250 line;
            if (useDelimiters && statType instanceof StatListDelimiter && delimiterNeeded) {
                identifications.add((class_2561)class_2561.method_43470((String)""));
                delimiterNeeded = false;
            }
            if (!allStats.contains(statType) || (line = TooltipIdentifications.getStatLine(statType, itemInfo, currentClass, decorator, style)) == null) continue;
            identifications.add((class_2561)line);
            delimiterNeeded = true;
        }
        if (!identifications.isEmpty() && ((class_2561)identifications.getLast()).getString().isEmpty()) {
            identifications.removeLast();
        }
        return identifications;
    }

    private static class_5250 getStatLine(StatType statType, IdentifiableItemProperty<?, ?> itemInfo, ClassType currentClass, TooltipIdentificationDecorator decorator, TooltipStyle style) {
        if (!itemInfo.getIdentifications().isEmpty()) {
            StatActualValue statActualValue = itemInfo.getIdentifications().stream().filter(stat -> stat.statType() == statType).findFirst().orElse(null);
            if (statActualValue == null) {
                WynntilsMod.warn("Missing value in item " + itemInfo.getName() + " for stat: " + String.valueOf(statType));
                return null;
            }
            class_5250 line = TooltipIdentifications.buildIdentifiedLine(itemInfo, style, statActualValue, currentClass);
            StatPossibleValues possibleValues = itemInfo.getPossibleValues().stream().filter(stat -> stat.statType() == statType).findFirst().orElse(null);
            if (possibleValues == null) {
                WynntilsMod.warn("Missing stat type in item " + itemInfo.getName() + " for stat: " + String.valueOf(statType) + " which has value: " + statActualValue.value());
                return line;
            }
            if (possibleValues.range().isFixed() || decorator == null) {
                return line;
            }
            line.method_10852((class_2561)decorator.getSuffix(statActualValue, possibleValues, style));
            return line;
        }
        StatPossibleValues possibleValues = itemInfo.getPossibleValues().stream().filter(stat -> stat.statType() == statType).findFirst().orElse(null);
        if (possibleValues == null) {
            WynntilsMod.warn("Missing possible values for stat type in item " + itemInfo.getName() + " for stat: " + String.valueOf(statType));
            return null;
        }
        return TooltipIdentifications.buildUnidentifiedLine(itemInfo, style, possibleValues);
    }

    private static class_5250 buildIdentifiedLine(IdentifiableItemProperty itemInfo, TooltipStyle style, StatActualValue actualValue, ClassType currentClass) {
        StatType statType = actualValue.statType();
        int value = actualValue.value();
        int valueToShow = statType.calculateAsInverted() ? -value : value;
        boolean hasPositiveEffect = valueToShow > 0 ^ statType.displayAsInverted();
        String starString = style.showStars() ? "***".substring(3 - actualValue.stars()) : "";
        class_5250 line = class_2561.method_43470((String)(StringUtils.toSignedString(valueToShow) + statType.getUnit().getDisplayName())).method_27696(class_2583.field_24360.method_10977(hasPositiveEffect ? class_124.field_1060 : class_124.field_1061));
        if (!starString.isEmpty()) {
            line.method_10852((class_2561)class_2561.method_43470((String)starString).method_27692(hasPositiveEffect ? class_124.field_1077 : class_124.field_1079));
        }
        line.method_10852((class_2561)class_2561.method_43470((String)(" " + Models.Stat.getDisplayName(statType, itemInfo.getRequiredClass(), currentClass, itemInfo.getIdentificationLevelRange()))).method_27692(class_124.field_1080));
        return line;
    }

    private static class_5250 buildUnidentifiedLine(IdentifiableItemProperty itemInfo, TooltipStyle style, StatPossibleValues possibleValues) {
        StatType statType = possibleValues.statType();
        RangedValue valueRange = possibleValues.range();
        Pair<Integer, Integer> displayRange = StatCalculator.getDisplayRange(possibleValues, style.showBestValueLastAlways());
        boolean hasPositiveEffect = displayRange.a() > 0 ^ statType.displayAsInverted();
        class_124 colorCode = hasPositiveEffect ? class_124.field_1060 : class_124.field_1061;
        class_124 colorCodeDark = hasPositiveEffect ? class_124.field_1077 : class_124.field_1079;
        class_5250 line = class_2561.method_43470((String)StringUtils.toSignedString(displayRange.a())).method_27692(colorCode);
        line.method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(colorCodeDark));
        line.method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(displayRange.b()) + statType.getUnit().getDisplayName())).method_27692(colorCode));
        line.method_10852((class_2561)class_2561.method_43470((String)(" " + Models.Stat.getDisplayName(statType, itemInfo.getRequiredClass(), Models.Character.getClassType(), itemInfo.getIdentificationLevelRange()))).method_27692(class_124.field_1080));
        return line;
    }
}

