/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.discoveries;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.activities.type.DiscoveryType;
import com.wynntils.utils.mc.ComponentUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public record DiscoveryInfo(String name, DiscoveryType type, String description, int minLevel, boolean discovered, List<String> requirements, List<class_2561> displayLore) {
    public DiscoveryInfo(String name, DiscoveryType type, String description, int minLevel, boolean discovered) {
        this(name, type, description, minLevel, discovered, List.of(), DiscoveryInfo.generateLore(name, type, description, minLevel, discovered));
    }

    public static DiscoveryInfo fromActivityInfo(ActivityInfo activityInfo) {
        return new DiscoveryInfo(activityInfo.name(), DiscoveryType.fromActivityType(activityInfo.type()), activityInfo.description().orElse(StyledText.EMPTY).getString(), activityInfo.requirements().level().key(), activityInfo.status() == ActivityStatus.COMPLETED);
    }

    private static List<class_2561> generateLore(String name, DiscoveryType type, String description, int minLevel, boolean discovered) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add((class_2561)class_2561.method_43470((String)name).method_27692(type.getColor()).method_27692(class_124.field_1067));
        if (Models.CombatXp.getCombatLevel().current() >= minLevel) {
            lore.add((class_2561)class_2561.method_43470((String)"\u2714").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)" Combat Lv. Min: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(minLevel)).method_27692(class_124.field_1068))));
        } else {
            lore.add((class_2561)class_2561.method_43470((String)"\u2718").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)" Combat Lv. Min: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(minLevel)).method_27692(class_124.field_1068))));
        }
        lore.add((class_2561)class_2561.method_43473());
        if (discovered) {
            lore.add((class_2561)class_2561.method_43470((String)"Discovered").method_27692(class_124.field_1060));
        } else {
            lore.add((class_2561)class_2561.method_43470((String)"Not Discovered").method_27692(class_124.field_1061));
        }
        if (!description.isEmpty()) {
            lore.add((class_2561)class_2561.method_43473());
            lore.addAll(ComponentUtils.wrapTooltips(List.of(class_2561.method_43470((String)description).method_27692(class_124.field_1080)), 300));
        }
        return lore;
    }
}

