/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats.actionbar.matchers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.segments.HealthBarSegment;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HealthBarSegmentMatcher
implements ActionBarSegmentMatcher {
    private static final String HEALTH_BACKGROUND_CHARS = "\ue029\ue039\ue049\ue059\ue069";
    private static final String HEALTH_BACKGROUND_SPACER = "\udaff\udf9c";
    private static final Pattern BACKGROUND_PATTERN = Pattern.compile("\udaff\udf9c[\ue029\ue039\ue049\ue059\ue069]");
    private static final Pattern BAR_END_PATTERN = Pattern.compile("(?<normalEnd>\udb00\udc20)|(?<highlightedEnd>\udaff\udfbc\ue069\udb00\udc1b)");
    private static final List<String> HEALTH_BAR_CHARS = List.of("\ue020-\ue028", "\ue030-\ue038", "\ue040-\ue048", "\ue050-\ue058");
    private static final Pattern HEALTH_BAR_PATTERN = Pattern.compile("(.[" + String.join((CharSequence)"", HEALTH_BAR_CHARS) + "]){10}");

    @Override
    public ActionBarSegment parse(String actionBar) {
        Matcher matcher = BACKGROUND_PATTERN.matcher(actionBar);
        if (!matcher.find()) {
            return null;
        }
        int beginIndex = actionBar.indexOf(matcher.group());
        Matcher endMatcher = BAR_END_PATTERN.matcher(actionBar);
        if (!endMatcher.find(beginIndex)) {
            WynntilsMod.warn("Found health bar background, but couldn't find the end of the segment: " + actionBar);
            return null;
        }
        String segmentText = actionBar.substring(beginIndex, endMatcher.end());
        String healthBarText = segmentText.substring(matcher.group().length(), segmentText.length() - endMatcher.group().length());
        if (!HEALTH_BAR_PATTERN.matcher(healthBarText).matches()) {
            WynntilsMod.warn("Health bar segment seems to match, but the bar text is not expected: " + healthBarText);
            return null;
        }
        return new HealthBarSegment(segmentText);
    }
}

