/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.containers.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public record ContainerBounds(int startRow, int startCol, int endRow, int endCol, List<Integer> slots) {
    public ContainerBounds(int startRow, int startCol, int endRow, int endCol) {
        this(startRow, startCol, endRow, endCol, ContainerBounds.buildSlots(startRow, startCol, endRow, endCol));
    }

    private static List<Integer> buildSlots(int startRow, int startCol, int endRow, int endCol) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < (endRow + 1) * 9; ++slot) {
            if (!ContainerBounds.isInBounds(slot, startRow, startCol, endRow, endCol)) continue;
            slots.add(slot);
        }
        return Collections.unmodifiableList(slots);
    }

    private static boolean isInBounds(int slot, int startRow, int startCol, int endRow, int endCol) {
        int row = slot / 9;
        int col = slot % 9;
        return row >= startRow && row <= endRow && col >= startCol && col <= endCol;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }
}

