/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.game;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GameItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.game.TeleportScrollItem;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;

public final class TeleportScrollAnnotator
implements GameItemAnnotator {
    private static final Pattern TELEPORT_SCROLL_PATTERN = Pattern.compile("^\u00a7#8193ffff(.*) Teleportation Scroll \u00a7#f9e79eff\\[(\\d)/(\\d)]$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        Matcher nameMatcher = name.getMatcher(TELEPORT_SCROLL_PATTERN);
        if (!nameMatcher.matches()) {
            return null;
        }
        String scrollName = nameMatcher.group(1);
        int remainingCharges = Integer.parseInt(nameMatcher.group(2));
        if (scrollName.equals("The Forgery")) {
            return new TeleportScrollItem("For", true, remainingCharges);
        }
        String destination = Services.Destination.getAbbreviation(scrollName);
        return new TeleportScrollItem(destination, false, remainingCharges);
    }
}

