/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.gui.StoreItem;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.LoreUtils;
import java.util.LinkedList;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public final class StoreTierAnnotator
implements GuiItemAnnotator {
    private static final class_2960 RARITY_FONT = class_2960.method_60656((String)"banner/box");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        LinkedList<StyledText> lore = LoreUtils.getLore(itemStack);
        if (lore.isEmpty()) {
            return null;
        }
        StyledText firstLine = (StyledText)lore.getFirst();
        if (!firstLine.getFirstPart().getPartStyle().getFont().equals((Object)RARITY_FONT)) {
            return null;
        }
        StoreTier tier = StoreTier.parseTier(firstLine.getStringWithoutFormatting());
        if (tier == null) {
            return null;
        }
        return new StoreItem(tier.getHighlightColor());
    }

    private static enum StoreTier {
        BLACK_MARKET("\ue060\udaff\udfff\ue031\udaff\udfff\ue03b\udaff\udfff\ue030\udaff\udfff\ue032\udaff\udfff\ue03a\udaff\udfff\ue061\udaff\udfff\ue03c\udaff\udfff\ue030\udaff\udfff\ue041\udaff\udfff\ue03a\udaff\udfff\ue034\udaff\udfff\ue043\udaff\udfff\ue062\udaff\udfb8\ue001\ue00b\ue000\ue002\ue00a \ue00c\ue000\ue011\ue00a\ue004\ue013\udb00\udc02", CustomColor.fromInt(0x640404)),
        GODLY("\ue060\udaff\udfff\ue036\udaff\udfff\ue03e\udaff\udfff\ue033\udaff\udfff\ue03b\udaff\udfff\ue048\udaff\udfff\ue062\udaff\udfe0\ue006\ue00e\ue003\ue00b\ue018\udb00\udc02", CustomColor.fromInt(15412525)),
        EPIC("\ue060\udaff\udfff\ue034\udaff\udfff\ue03f\udaff\udfff\ue038\udaff\udfff\ue032\udaff\udfff\ue062\udaff\udfe8\ue004\ue00f\ue008\ue002\udb00\udc02", CustomColor.fromInt(0xFFBB00)),
        RARE("\ue060\udaff\udfff\ue041\udaff\udfff\ue030\udaff\udfff\ue041\udaff\udfff\ue034\udaff\udfff\ue062\udaff\udfe6\ue011\ue000\ue011\ue004\udb00\udc02", CustomColor.fromInt(0xDD55FF)),
        COMMON("\ue060\udaff\udfff\ue032\udaff\udfff\ue03e\udaff\udfff\ue03c\udaff\udfff\ue03c\udaff\udfff\ue03e\udaff\udfff\ue03d\udaff\udfff\ue062\udaff\udfda\ue002\ue00e\ue00c\ue00c\ue00e\ue00d\udb00\udc02", CustomColor.fromInt(0xFFFDDD));

        private final String rarityText;
        private final CustomColor highlightColor;

        private StoreTier(String rarityText, CustomColor highlightColor) {
            this.rarityText = rarityText;
            this.highlightColor = highlightColor;
        }

        public static StoreTier parseTier(String rarityText) {
            for (StoreTier tier : StoreTier.values()) {
                if (!rarityText.startsWith(tier.rarityText)) continue;
                return tier;
            }
            return null;
        }

        public CustomColor getHighlightColor() {
            return this.highlightColor;
        }
    }
}

