/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.data;

import com.wynntils.models.items.encoding.type.ItemData;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import java.util.Optional;
import java.util.regex.Pattern;

public record NameData(Optional<String> name) implements ItemData
{
    private static final NameData EMPTY = new NameData(Optional.empty());
    private static final int MAX_NAME_LENGTH = 50;
    private static final Pattern SANITIZE_PATTERN = Pattern.compile("[^a-zA-Z0-9'\\-.,!?\\s]");

    public static NameData fromSafeName(IdentifiableItemProperty property) {
        return new NameData(Optional.ofNullable(property.getName()));
    }

    public static NameData sanitized(String name) {
        if (SANITIZE_PATTERN.matcher(name).find()) {
            return EMPTY;
        }
        name = name.trim();
        name = name.replaceAll("\\s+", " ");
        name = name.substring(0, Math.min(name.length(), 50));
        return new NameData(Optional.of(name));
    }
}

