/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.gear.type.ConsumableType;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.models.items.properties.DurationItemProperty;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.models.items.properties.UsesItemProperty;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.wynnitem.type.ConsumableEffect;
import com.wynntils.models.wynnitem.type.ItemEffect;
import com.wynntils.models.wynnitem.type.NamedItemEffect;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.RangedValue;
import java.util.List;

public class CraftedConsumableItem
extends GameItem
implements UsesItemProperty,
GearTierItemProperty,
LeveledItemProperty,
CraftedItemProperty,
DurationItemProperty {
    private final String name;
    private final ConsumableType consumableType;
    private final int level;
    private final int duration;
    private final List<StatActualValue> identifications;
    private final List<NamedItemEffect> namedEffects;
    private final List<ItemEffect> effects;
    private final CappedValue uses;

    public CraftedConsumableItem(String name, ConsumableType consumableType, int level, List<StatActualValue> identifications, List<NamedItemEffect> namedEffects, List<ItemEffect> effects, CappedValue uses) {
        this.name = name;
        this.consumableType = consumableType;
        this.level = level;
        this.identifications = identifications;
        this.namedEffects = namedEffects;
        this.effects = effects;
        this.uses = uses;
        this.duration = namedEffects.stream().filter(namedItemEffect -> namedItemEffect.type() == ConsumableEffect.DURATION).findFirst().map(NamedItemEffect::value).orElse(0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ConsumableType getConsumableType() {
        return this.consumableType;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public List<StatType> getStatTypes() {
        return this.identifications.stream().map(StatActualValue::statType).toList();
    }

    @Override
    public List<StatActualValue> getIdentifications() {
        return this.identifications;
    }

    @Override
    public List<StatPossibleValues> getPossibleValues() {
        return this.identifications.stream().map(stat -> new StatPossibleValues(stat.statType(), RangedValue.of(stat.value(), stat.value()), stat.value(), false)).toList();
    }

    @Override
    public ClassType getRequiredClass() {
        return null;
    }

    public List<NamedItemEffect> getNamedEffects() {
        return this.namedEffects;
    }

    public List<ItemEffect> getEffects() {
        return this.effects;
    }

    @Override
    public CappedValue getUses() {
        return this.uses;
    }

    @Override
    public GearTier getGearTier() {
        return GearTier.CRAFTED;
    }

    public boolean isHealing() {
        return this.getEffects().stream().anyMatch(e -> e.type().equals("Heal"));
    }

    @Override
    public String toString() {
        return "CraftedConsumableItem{name='" + this.name + "', consumableType=" + String.valueOf((Object)this.consumableType) + ", level=" + this.level + ", duration=" + this.duration + ", identifications=" + String.valueOf(this.identifications) + ", namedEffects=" + String.valueOf(this.namedEffects) + ", effects=" + String.valueOf(this.effects) + ", uses=" + String.valueOf(this.uses) + "}";
    }
}

