/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.objectives;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.scoreboard.ScoreboardSegment;
import com.wynntils.handlers.scoreboard.type.SegmentMatcher;
import com.wynntils.models.objectives.AbstractObjectivesScoreboardPart;
import com.wynntils.models.objectives.WynnObjective;
import java.util.ArrayList;
import java.util.List;

public class DailyObjectiveScoreboardPart
extends AbstractObjectivesScoreboardPart {
    private static final SegmentMatcher OBJECTIVES_MATCHER = SegmentMatcher.fromPattern("([\u2605\u2b51] )?(Daily )?Objectives?:");

    @Override
    public SegmentMatcher getSegmentMatcher() {
        return OBJECTIVES_MATCHER;
    }

    @Override
    public void onSegmentChange(ScoreboardSegment newValue) {
        if (DailyObjectiveScoreboardPart.isSegmentAllDone(newValue)) {
            WynntilsMod.info("Daily objectives were all done.");
            DailyObjectiveScoreboardPart.removeAllOfType();
            return;
        }
        List<WynnObjective> objectives = this.parseObjectives(newValue);
        if (objectives.isEmpty()) {
            WynntilsMod.warn("Daily objective segment changed, but no objectives were parsed.");
            WynntilsMod.warn(newValue.toString());
            return;
        }
        if (Models.Objectives.getPersonalObjectives().isEmpty()) {
            WynntilsMod.info("Adding " + objectives.size() + " daily objectives.");
        }
        for (WynnObjective objective : objectives) {
            if (objective.isGuildObjective()) continue;
            Models.Objectives.updatePersonalObjective(objective);
        }
        Models.Objectives.purgePersonalObjectives(objectives);
    }

    @Override
    public void onSegmentRemove(ScoreboardSegment segment) {
        DailyObjectiveScoreboardPart.removeAllOfType();
    }

    private static void removeAllOfType() {
        ArrayList<WynnObjective> personalObjectives = new ArrayList<WynnObjective>(Models.Objectives.getPersonalObjectives());
        personalObjectives.forEach(Models.Objectives::removeObjective);
    }

    @Override
    public String toString() {
        return "DailyObjectiveScoreboardPart{}";
    }
}

