/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.profession.label;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.models.profession.label.GatheringNodeHarvestLabelInfo;
import com.wynntils.models.profession.type.MaterialProfile;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.utils.mc.type.Location;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;

public class GatheringNodeHarvestLabelParser
implements LabelParser<GatheringNodeHarvestLabelInfo> {
    private static final Pattern EXPERIENCE_PATTERN = Pattern.compile("(\u00a7(.+?)\\[\u00a7(.+?)x\\d\u00a7(.+?)\\] )?\u00a7(.+?)\\+(\u00a7d)?(?<gain>\\d+) \u00a77[\u24c0\u24b8\u24b7\u24bf\u24ba\u24b9\u24c1\u24b6\u24bc\u24bb\u24be\u24bd] (?<name>.+) XP \u00a76\\[(?<current>[\\d.]+)%\\]");
    private static final Pattern HARVEST_PATTERN = Pattern.compile("(\u00a7(.+?)\\[\u00a7(.+?)x\\d\u00a7(.+?)\\] )?\u00a7(.+?)\\+\\d+ \u00a77(?<type>.+) (?<material>.+)\u00a76 \\[\u00a7e\u272b((?:\u00a78)?\u272b(?:\u00a78)?)\u272b\u00a76\\]");

    @Override
    public GatheringNodeHarvestLabelInfo getInfo(StyledText label, Location location, class_1297 entity) {
        StyledText[] lines = label.split("\n");
        if (lines.length == 0) {
            return null;
        }
        Matcher experienceMatcher = lines[0].getMatcher(EXPERIENCE_PATTERN);
        if (experienceMatcher.matches()) {
            Matcher materialMatcher;
            ProfessionType profession = ProfessionType.fromString(experienceMatcher.group("name"));
            float gain = Float.parseFloat(experienceMatcher.group("gain"));
            float current = Float.parseFloat(experienceMatcher.group("current"));
            Optional<MaterialProfile> gatheredMaterial = Optional.empty();
            if (lines.length == 2 && (materialMatcher = lines[1].getMatcher(HARVEST_PATTERN)).matches()) {
                String type = materialMatcher.group("type");
                String material = materialMatcher.group("material");
                String tierGroup = materialMatcher.group(8);
                gatheredMaterial = Optional.ofNullable(MaterialProfile.lookup(type, material, tierGroup));
            }
            return new GatheringNodeHarvestLabelInfo(label, location, entity, profession, gain, current, gatheredMaterial);
        }
        return null;
    }
}

