/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.territories;

import com.wynntils.core.text.StyledText;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.models.territories.type.GuildResourceValues;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TerritoryInfo {
    private static final Pattern NAME_PATTERN = Pattern.compile("(.+) \\[(.+)\\]\\s*");
    private static final Pattern GENERATOR_PATTERN = Pattern.compile("(.\\s)?\\+([0-9]*) (Emeralds|Ore|Wood|Fish|Crops) per Hour");
    private static final Pattern STORAGE_PATTERN = Pattern.compile("(.\\s)?([0-9]+)\\/([0-9]+) stored");
    private static final Pattern DEFENSE_PATTERN = Pattern.compile("Territory Defences: (.+)");
    private static final Pattern TREASURY_PATTERN = Pattern.compile("\u2726 Treasury: (.+)");
    private String guildName;
    private String guildPrefix;
    private final HashMap<GuildResource, CappedValue> storage = new HashMap();
    private final HashMap<GuildResource, Integer> generators = new HashMap();
    private final List<String> tradingRoutes = new ArrayList<String>();
    private GuildResourceValues treasury;
    private GuildResourceValues defences;
    private final boolean headquarters;
    private final List<CustomColor> resourceColors = new ArrayList<CustomColor>();

    public TerritoryInfo(String[] raw, StyledText[] colored, boolean headquarters) {
        this.headquarters = headquarters;
        for (int i = 0; i < raw.length; ++i) {
            Matcher m;
            String unformatted = raw[i];
            StyledText formatted = colored[i];
            if (unformatted.startsWith("-")) {
                this.tradingRoutes.add(unformatted.substring(2));
                continue;
            }
            Matcher nameMatcher = NAME_PATTERN.matcher(unformatted);
            if (nameMatcher.matches()) {
                this.guildName = nameMatcher.group(1);
                this.guildPrefix = nameMatcher.group(2);
                continue;
            }
            Matcher treasureMatcher = TREASURY_PATTERN.matcher(unformatted);
            if (treasureMatcher.matches()) {
                this.treasury = GuildResourceValues.fromString(treasureMatcher.group(1));
                continue;
            }
            Matcher defenseMatcher = DEFENSE_PATTERN.matcher(unformatted);
            if (defenseMatcher.matches()) {
                this.defences = GuildResourceValues.fromString(defenseMatcher.group(1));
                continue;
            }
            GuildResource resource = null;
            for (GuildResource type : GuildResource.values()) {
                if (!formatted.contains(type.getColor().toString())) continue;
                resource = type;
                break;
            }
            if (resource == null) continue;
            if (unformatted.contains("per Hour")) {
                m = GENERATOR_PATTERN.matcher(unformatted);
                if (!m.matches()) continue;
                this.generators.put(resource, Integer.parseInt(m.group(2)));
                continue;
            }
            m = STORAGE_PATTERN.matcher(unformatted);
            if (!m.matches()) continue;
            this.storage.put(resource, new CappedValue(Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3))));
        }
        for (Map.Entry<GuildResource, Integer> generator : this.generators.entrySet()) {
            switch (generator.getKey()) {
                case ORE: {
                    this.resourceColors.add(CustomColor.fromHSV(0.0f, 0.3f, 1.0f, 1.0f));
                    break;
                }
                case FISH: {
                    this.resourceColors.add(CustomColor.fromHSV(0.5f, 0.6f, 0.9f, 1.0f));
                    break;
                }
                case WOOD: {
                    this.resourceColors.add(CustomColor.fromHSV(0.33333334f, 0.6f, 0.9f, 1.0f));
                    break;
                }
                case CROPS: {
                    this.resourceColors.add(CustomColor.fromHSV(0.16666667f, 0.6f, 0.9f, 1.0f));
                }
            }
        }
        if (this.resourceColors.isEmpty()) {
            this.resourceColors.add(CommonColors.WHITE);
        }
    }

    public String getGuildName() {
        return this.guildName;
    }

    public String getGuildPrefix() {
        return this.guildPrefix;
    }

    public Map<GuildResource, Integer> getGenerators() {
        return this.generators;
    }

    public Map<GuildResource, CappedValue> getStorage() {
        return this.storage;
    }

    public List<String> getTradingRoutes() {
        return this.tradingRoutes;
    }

    public Integer getGeneration(GuildResource resource) {
        return this.generators.getOrDefault((Object)resource, 0);
    }

    public CappedValue getStorage(GuildResource resource) {
        return this.storage.get((Object)resource);
    }

    public GuildResourceValues getTreasury() {
        return this.treasury;
    }

    public GuildResourceValues getDefences() {
        return this.defences;
    }

    public List<CustomColor> getResourceColors() {
        return this.resourceColors;
    }

    public boolean isHeadquarters() {
        return this.headquarters;
    }
}

