/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.filters;

import com.wynntils.core.components.Services;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.widgets.filters.GuideFilterButton;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.services.itemfilter.filters.StringStatFilter;
import com.wynntils.services.itemfilter.statproviders.GearTypeStatProvider;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_332;

public class GearTypeFilterWidget
extends GuideFilterWidget {
    private final List<GearTypeButton> gearTypeButtons = new ArrayList<GearTypeButton>();
    private GearTypeStatProvider provider;

    public GearTypeFilterWidget(int x, int y, WynntilsGuideScreen guideScreen, ItemSearchQuery searchQuery) {
        super(x, y, 136, 36, guideScreen);
        this.gearTypeButtons.add(new GearTypeButton(x, y, GearType.HELMET, Texture.HELMET_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 20, y, GearType.CHESTPLATE, Texture.CHESTPLATE_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 40, y, GearType.LEGGINGS, Texture.LEGGINGS_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 60, y, GearType.BOOTS, Texture.BOOTS_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 80, y, GearType.RING, Texture.RING_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 100, y, GearType.BRACELET, Texture.BRACELET_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 120, y, GearType.NECKLACE, Texture.NECKLACE_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x, y + 20, GearType.SPEAR, Texture.SPEAR_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 20, y + 20, GearType.WAND, Texture.WAND_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 40, y + 20, GearType.DAGGER, Texture.DAGGER_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 60, y + 20, GearType.BOW, Texture.BOW_FILTER_ICON, searchQuery));
        this.gearTypeButtons.add(new GearTypeButton(x + 80, y + 20, GearType.RELIK, Texture.RELIK_FILTER_ICON, searchQuery));
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.gearTypeButtons.forEach(widget -> widget.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = false;
        for (GearTypeButton gearTypeButton : this.gearTypeButtons) {
            if (!gearTypeButton.method_25405(mouseX, mouseY)) continue;
            clicked = gearTypeButton.method_25402(mouseX, mouseY, button);
            break;
        }
        this.guideScreen.updateSearchFromQuickFilters();
        return clicked;
    }

    @Override
    protected List<StatProviderAndFilterPair> getFilters() {
        ArrayList<StatProviderAndFilterPair> filterPairs = new ArrayList<StatProviderAndFilterPair>();
        for (GearTypeButton gearTypeButton : this.gearTypeButtons) {
            StatProviderAndFilterPair filterPair = gearTypeButton.getFilterPair(this.provider);
            if (filterPair == null) continue;
            filterPairs.add(filterPair);
        }
        return filterPairs;
    }

    @Override
    public void getProvider() {
        this.provider = Services.ItemFilter.getItemStatProviders().stream().filter(statProvider -> statProvider instanceof GearTypeStatProvider).map(statProvider -> (GearTypeStatProvider)statProvider).findFirst().orElseThrow(() -> new IllegalStateException("Could not get gear type stat provider"));
    }

    @Override
    public void updateFromQuery(ItemSearchQuery searchQuery) {
        this.gearTypeButtons.forEach(classTypeButton -> classTypeButton.updateStateFromQuery(searchQuery));
    }

    private static class GearTypeButton
    extends GuideFilterButton<GearTypeStatProvider> {
        private final GearType gearType;

        protected GearTypeButton(int x, int y, GearType gearType, Texture texture, ItemSearchQuery searchQuery) {
            super(x, y, texture);
            this.gearType = gearType;
            this.updateStateFromQuery(searchQuery);
        }

        @Override
        protected void updateStateFromQuery(ItemSearchQuery searchQuery) {
            this.state = searchQuery.filters().values().stream().filter(filterPair -> filterPair.statProvider() instanceof GearTypeStatProvider).anyMatch(filterPair -> filterPair.statFilter().matches(EnumUtils.toNiceString(this.gearType)));
        }

        @Override
        protected StatProviderAndFilterPair getFilterPair(GearTypeStatProvider provider) {
            if (!this.state) {
                return null;
            }
            Optional<StringStatFilter> statFilterOpt = new StringStatFilter.StringStatFilterFactory().create(EnumUtils.toNiceString(this.gearType));
            return statFilterOpt.map(stringStatFilter -> new StatProviderAndFilterPair<String>(provider, (StatFilter<String>)stringStatFilter)).orElse(null);
        }

        @Override
        protected String getFilterName() {
            return class_1074.method_4662((String)"service.wynntils.itemFilter.stat.gearType.name", (Object[])new Object[0]) + " " + EnumUtils.toNiceString(this.gearType);
        }
    }
}

