/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.filters;

import com.wynntils.core.components.Services;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.widgets.filters.GuideFilterButton;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.services.itemfilter.filters.RangedStatFilters;
import com.wynntils.services.itemfilter.statproviders.QualityTierStatProvider;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_332;

public class QualityTierFilterWidget
extends GuideFilterWidget {
    private final List<QualityTierButton> qualityTierButtons = new ArrayList<QualityTierButton>();
    private QualityTierStatProvider provider;

    public QualityTierFilterWidget(int x, int y, WynntilsGuideScreen guideScreen, ItemSearchQuery searchQuery) {
        super(x, y, 76, 16, guideScreen);
        this.qualityTierButtons.add(new QualityTierButton(x, y, 0, Texture.TIER_0_FILTER_ICON, searchQuery));
        this.qualityTierButtons.add(new QualityTierButton(x + 20, y, 1, Texture.TIER_1_FILTER_ICON, searchQuery));
        this.qualityTierButtons.add(new QualityTierButton(x + 40, y, 2, Texture.TIER_2_FILTER_ICON, searchQuery));
        this.qualityTierButtons.add(new QualityTierButton(x + 60, y, 3, Texture.TIER_3_FILTER_ICON, searchQuery));
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.qualityTierButtons.forEach(widget -> widget.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = false;
        for (QualityTierButton qualityTierButton : this.qualityTierButtons) {
            if (!qualityTierButton.method_25405(mouseX, mouseY)) continue;
            clicked = qualityTierButton.method_25402(mouseX, mouseY, button);
            break;
        }
        this.guideScreen.updateSearchFromQuickFilters();
        return clicked;
    }

    @Override
    protected List<StatProviderAndFilterPair> getFilters() {
        ArrayList<StatProviderAndFilterPair> filterPairs = new ArrayList<StatProviderAndFilterPair>();
        for (QualityTierButton qualityTierButton : this.qualityTierButtons) {
            StatProviderAndFilterPair filterPair = qualityTierButton.getFilterPair(this.provider);
            if (filterPair == null) continue;
            filterPairs.add(filterPair);
        }
        return filterPairs;
    }

    @Override
    public void getProvider() {
        this.provider = Services.ItemFilter.getItemStatProviders().stream().filter(statProvider -> statProvider instanceof QualityTierStatProvider).map(statProvider -> (QualityTierStatProvider)statProvider).findFirst().orElseThrow(() -> new IllegalStateException("Could not get quality tier stat provider"));
    }

    @Override
    public void updateFromQuery(ItemSearchQuery searchQuery) {
        this.qualityTierButtons.forEach(classTypeButton -> classTypeButton.updateStateFromQuery(searchQuery));
    }

    private static class QualityTierButton
    extends GuideFilterButton<QualityTierStatProvider> {
        private final int tier;

        protected QualityTierButton(int x, int y, int tier, Texture texture, ItemSearchQuery searchQuery) {
            super(x, y, texture);
            this.tier = tier;
            this.updateStateFromQuery(searchQuery);
        }

        @Override
        protected void updateStateFromQuery(ItemSearchQuery searchQuery) {
            this.state = searchQuery.filters().values().stream().filter(filterPair -> filterPair.statProvider() instanceof QualityTierStatProvider).anyMatch(filterPair -> filterPair.statFilter().matches(this.tier));
        }

        @Override
        protected StatProviderAndFilterPair getFilterPair(QualityTierStatProvider provider) {
            if (!this.state) {
                return null;
            }
            Optional statFilterOpt = new RangedStatFilters.RangedIntegerStatFilter.RangedIntegerStatFilterFactory().create(String.valueOf(this.tier));
            return statFilterOpt.map(stringStatFilter -> new StatProviderAndFilterPair<Integer>(provider, (StatFilter<Integer>)stringStatFilter)).orElse(null);
        }

        @Override
        protected String getFilterName() {
            return class_1074.method_4662((String)"service.wynntils.itemFilter.stat.qualityTier.name", (Object[])new Object[0]) + " " + this.tier;
        }
    }
}

