/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.debug.MappingProgressFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.services.map.MapTexture;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.MapRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.PointerType;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.type.BoundingShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_9799;

public abstract class AbstractMapScreen
extends WynntilsScreen {
    protected static final class_4597.class_4598 BUFFER_SOURCE = class_4597.method_22991((class_9799)new class_9799(256));
    protected static final float SCREEN_SIDE_OFFSET = 10.0f;
    protected static final int MAP_CENTER_X = -360;
    protected static final int MAP_CENTER_Z = -3000;
    private static final float BORDER_OFFSET = 6.0f;
    private static final int MAX_X = 1650;
    private static final int MAX_Z = -150;
    private static final int MIN_X = -2400;
    private static final int MIN_Z = -6600;
    private static final int CENTER_ZOOM_LEVEL = 20;
    protected boolean holdingMapKey = false;
    protected boolean firstInit = true;
    protected float renderWidth;
    protected float renderHeight;
    protected float renderX;
    protected float renderY;
    protected float renderedBorderXOffset;
    protected float renderedBorderYOffset;
    protected float mapWidth;
    protected float mapHeight;
    protected float centerX;
    protected float centerZ;
    protected float mapCenterX;
    protected float mapCenterZ;
    protected float zoomLevel = 60.0f;
    protected float zoomRenderScale = MapRenderer.getZoomRenderScaleFromLevel(this.zoomLevel);
    protected Poi hovered = null;

    protected AbstractMapScreen() {
        super((class_2561)class_2561.method_43470((String)"Map"));
        this.centerMapAroundPlayer();
    }

    protected AbstractMapScreen(float mapCenterX, float mapCenterZ) {
        super((class_2561)class_2561.method_43470((String)"Map"));
        this.updateMapCenter(mapCenterX, mapCenterZ);
    }

    @Override
    protected void doInit() {
        class_315 options = McUtils.options();
        class_304.method_1416((class_3675.class_306)options.field_1894.field_1655, (boolean)KeyboardUtils.isKeyDown(options.field_1894.field_1655.method_1444()));
        class_304.method_1416((class_3675.class_306)options.field_1881.field_1655, (boolean)KeyboardUtils.isKeyDown(options.field_1881.field_1655.method_1444()));
        class_304.method_1416((class_3675.class_306)options.field_1913.field_1655, (boolean)KeyboardUtils.isKeyDown(options.field_1913.field_1655.method_1444()));
        class_304.method_1416((class_3675.class_306)options.field_1849.field_1655, (boolean)KeyboardUtils.isKeyDown(options.field_1849.field_1655.method_1444()));
        class_304.method_1416((class_3675.class_306)options.field_1903.field_1655, (boolean)KeyboardUtils.isKeyDown(options.field_1903.field_1655.method_1444()));
        class_304.method_1416((class_3675.class_306)options.field_1832.field_1655, (boolean)KeyboardUtils.isKeyDown(options.field_1832.field_1655.method_1444()));
        this.renderWidth = (float)this.field_22789 - 20.0f;
        this.renderHeight = (float)this.field_22790 - 20.0f;
        this.renderX = 10.0f;
        this.renderY = 10.0f;
        float borderScaleX = (float)this.field_22789 / (float)Texture.FULLSCREEN_MAP_BORDER.width();
        float borderScaleY = (float)this.field_22790 / (float)Texture.FULLSCREEN_MAP_BORDER.height();
        this.renderedBorderXOffset = 6.0f * borderScaleX;
        this.renderedBorderYOffset = 6.0f * borderScaleY;
        this.mapWidth = this.renderWidth - this.renderedBorderXOffset * 2.0f;
        this.mapHeight = this.renderHeight - this.renderedBorderYOffset * 2.0f;
        this.centerX = this.renderX + this.renderedBorderXOffset + this.mapWidth / 2.0f;
        this.centerZ = this.renderY + this.renderedBorderYOffset + this.mapHeight / 2.0f;
    }

    protected void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        for (class_364 child : this.field_22786) {
            if (!(child instanceof TooltipProvider)) continue;
            TooltipProvider tooltipProvider = (TooltipProvider)child;
            if (!child.method_25405((double)mouseX, (double)mouseY)) continue;
            guiGraphics.method_51434(FontRenderer.getInstance().getFont(), tooltipProvider.getTooltipLines(), mouseX, mouseY);
            return;
        }
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.FULLSCREEN_MAP_BORDER.resource(), this.renderX, this.renderY, 100.0f, this.renderWidth, this.renderHeight, Texture.FULLSCREEN_MAP_BORDER.width(), Texture.FULLSCREEN_MAP_BORDER.height());
    }

    protected void renderPois(List<Poi> pois, class_4587 poseStack, BoundingBox textureBoundingBox, float poiScale, int mouseX, int mouseY) {
        this.hovered = null;
        List<Poi> filteredPois = this.getRenderedPois(pois, textureBoundingBox, poiScale, mouseX, mouseY);
        class_4597.class_4598 bufferSource = McUtils.mc().method_22940().method_23000();
        for (int i = filteredPois.size() - 1; i >= 0; --i) {
            Poi poi = filteredPois.get(i);
            float poiRenderX = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            float poiRenderZ = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            poi.renderAt(poseStack, (class_4597)bufferSource, poiRenderX, poiRenderZ, this.hovered == poi, poiScale, this.zoomRenderScale, this.zoomLevel, true);
        }
        bufferSource.method_22993();
    }

    protected List<Poi> getRenderedPois(List<Poi> pois, BoundingBox textureBoundingBox, float poiScale, int mouseX, int mouseY) {
        ArrayList<Poi> filteredPois = new ArrayList<Poi>();
        for (int i = pois.size() - 1; i >= 0; --i) {
            Poi poi = pois.get(i);
            PoiLocation location = poi.getLocation();
            if (location == null || !poi.isVisible(this.zoomRenderScale, this.zoomLevel)) continue;
            float poiRenderX = MapRenderer.getRenderX(poi, this.mapCenterX, this.centerX, this.zoomRenderScale);
            float poiRenderZ = MapRenderer.getRenderZ(poi, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
            float poiWidth = poi.getWidth(this.zoomRenderScale, poiScale);
            float poiHeight = poi.getHeight(this.zoomRenderScale, poiScale);
            BoundingBox filterBox = BoundingBox.centered(location.getX(), location.getZ(), poiWidth, poiHeight);
            BoundingBox mouseBox = BoundingBox.centered(poiRenderX, poiRenderZ, poiWidth, poiHeight);
            if (!BoundingShape.intersects(filterBox, textureBoundingBox)) continue;
            filteredPois.add(poi);
            if (this.hovered != null || !mouseBox.contains(mouseX, mouseY)) continue;
            this.hovered = poi;
        }
        if (this.hovered != null) {
            filteredPois.remove(this.hovered);
            filteredPois.addFirst(this.hovered);
        }
        return filteredPois;
    }

    protected void setCompassToMouseCoords(double mouseX, double mouseY, boolean removeAll) {
        if (removeAll) {
            MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        }
        double gameX = (mouseX - (double)this.centerX) / (double)this.zoomRenderScale + (double)this.mapCenterX;
        double gameZ = (mouseY - (double)this.centerZ) / (double)this.zoomRenderScale + (double)this.mapCenterZ;
        Location compassLocation = Location.containing(gameX, 0.0, gameZ);
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(compassLocation, null);
        McUtils.playSoundUI(class_3417.field_14627);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.adjustZoomLevel((float)(2.0 * deltaY));
        return true;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (keyCode == 61 || keyCode == 334) {
            this.adjustZoomLevel(2.0f);
            return true;
        }
        if (keyCode == 45 || keyCode == 333) {
            this.adjustZoomLevel(-2.0f);
            return true;
        }
        class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
        class_304.method_1416((class_3675.class_306)key, (boolean)true);
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
        class_304.method_1416((class_3675.class_306)key, (boolean)false);
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && mouseX >= (double)this.renderX && mouseX <= (double)(this.renderX + this.renderWidth) && mouseY >= (double)this.renderY && mouseY <= (double)(this.renderY + this.renderHeight)) {
            this.updateMapCenter((float)((double)this.mapCenterX - dragX / (double)this.zoomRenderScale), (float)((double)this.mapCenterZ - dragY / (double)this.zoomRenderScale));
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    protected void renderCoordinates(class_4587 poseStack, int mouseX, int mouseY) {
        int gameX = (int)(((float)mouseX - this.centerX) / this.zoomRenderScale + this.mapCenterX);
        int gameZ = (int)(((float)mouseY - this.centerZ) / this.zoomRenderScale + this.mapCenterZ);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(gameX + ", " + gameZ), this.centerX, this.renderHeight - this.renderedBorderYOffset - 40.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.OUTLINE);
    }

    protected void renderZoomWidget(class_4587 poseStack, int mouseX, int mouseY) {
        if (!KeyboardUtils.isShiftDown()) {
            return;
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString("Zoom " + Math.round(this.zoomLevel)), this.renderX + this.renderedBorderXOffset + this.mapWidth - 40.0f, this.renderHeight - this.renderedBorderYOffset - 10.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.OUTLINE);
    }

    protected void renderMapButtons(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawTexturedRect(poseStack, Texture.MAP_BUTTONS_BACKGROUND, this.centerX - (float)Texture.MAP_BUTTONS_BACKGROUND.width() / 2.0f, this.renderHeight - this.renderedBorderYOffset - (float)Texture.MAP_BUTTONS_BACKGROUND.height());
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderCursor(class_4587 poseStack, float pointerScale, CustomColor pointerColor, PointerType pointerType) {
        double pX = McUtils.player().method_23317();
        double pZ = McUtils.player().method_23321();
        double distanceX = pX - (double)this.mapCenterX;
        double distanceZ = pZ - (double)this.mapCenterZ;
        float cursorX = (float)((double)this.centerX + distanceX * (double)this.zoomRenderScale);
        float cursorZ = (float)((double)this.centerZ + distanceZ * (double)this.zoomRenderScale);
        MapRenderer.renderCursor(poseStack, cursorX, cursorZ, pointerScale, pointerColor, pointerType, false);
    }

    protected void renderMap(class_332 guiGraphics) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.enableScissor(guiGraphics, (int)(this.renderX + this.renderedBorderXOffset), (int)(this.renderY + this.renderedBorderYOffset), (int)this.mapWidth, (int)this.mapHeight);
        RenderUtils.drawRect(poseStack, CommonColors.BLACK, this.renderX + this.renderedBorderXOffset, this.renderY + this.renderedBorderYOffset, 0.0f, this.mapWidth, this.mapHeight);
        BoundingBox textureBoundingBox = BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.field_22789 / this.zoomRenderScale, (float)this.field_22790 / this.zoomRenderScale);
        List<MapTexture> maps = Services.Map.getMapsForBoundingBox(textureBoundingBox);
        for (MapTexture map : maps) {
            float textureX = map.getTextureXPosition(this.mapCenterX);
            float textureZ = map.getTextureZPosition(this.mapCenterZ);
            MapRenderer.renderMapQuad(map, poseStack, (class_4597)BUFFER_SOURCE, this.centerX, this.centerZ, textureX, textureZ, this.mapWidth, this.mapHeight, 1.0f / this.zoomRenderScale);
        }
        BUFFER_SOURCE.method_22993();
        RenderUtils.disableScissor(guiGraphics);
    }

    protected void renderChunkBorders(class_4587 poseStack) {
        BoundingBox textureBoundingBox = BoundingBox.centered(this.mapCenterX, this.mapCenterZ, (float)this.field_22789 / this.zoomRenderScale, (float)this.field_22790 / this.zoomRenderScale);
        float pX = (float)McUtils.player().method_23317();
        float pZ = (float)McUtils.player().method_23321();
        BoundingBox chunkBoundingBox = KeyboardUtils.isShiftDown() ? textureBoundingBox : BoundingBox.centered(pX, pZ, (Integer)McUtils.options().method_42503().method_41753() * 16, (Integer)McUtils.options().method_42503().method_41753() * 16);
        Set<Long> mappedChunks = Managers.Feature.getFeatureInstance(MappingProgressFeature.class).getMappedChunks();
        MapRenderer.renderChunks(poseStack, BUFFER_SOURCE, chunkBoundingBox, mappedChunks, this.mapCenterX, this.centerX, this.mapCenterZ, this.centerZ, this.zoomRenderScale);
    }

    protected void centerMapAroundPlayer() {
        this.updateMapCenter((float)McUtils.player().method_23317(), (float)McUtils.player().method_23321());
    }

    protected void centerMapOnWorld() {
        this.updateMapCenter(-360.0f, -3000.0f);
        this.setZoomLevel(20.0f);
    }

    protected boolean isPlayerInsideMainArea() {
        return MathUtils.isInside((int)McUtils.player().method_23317(), (int)McUtils.player().method_23321(), -2400, 1650, -6600, -150);
    }

    protected void setZoomLevel(float zoomLevel) {
        this.zoomLevel = MathUtils.clamp(zoomLevel, 1.0f, 100.0f);
        this.zoomRenderScale = MapRenderer.getZoomRenderScaleFromLevel(this.zoomLevel);
    }

    private void adjustZoomLevel(float delta) {
        this.setZoomLevel(this.zoomLevel + delta);
    }

    protected void updateMapCenter(float newX, float newZ) {
        this.mapCenterX = newX;
        this.mapCenterZ = newZ;
    }

    public void setHoldingMapKey(boolean holdingMapKey) {
        this.holdingMapKey = holdingMapKey;
    }
}

