/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.secrets;

import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.secrets.widgets.SecretInputWidget;
import com.wynntils.services.secrets.type.WynntilsSecret;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;

public class SecretsScreen
extends WynntilsScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int SCROLL_AREA_HEIGHT = 121;
    private static final int WIDGETS_PER_PAGE = 6;
    private boolean draggingScroll = false;
    private float scrollY;
    private int scrollOffset = 0;
    private int offsetX;
    private int offsetY;
    private List<SecretInputWidget> secretInputs = new ArrayList<SecretInputWidget>();

    private SecretsScreen() {
        super((class_2561)class_2561.method_43470((String)"Wynntils Secrets Screen"));
    }

    public static SecretsScreen create() {
        return new SecretsScreen();
    }

    @Override
    public void doInit() {
        this.offsetX = (this.field_22789 - Texture.SECRETS_BACKGROUND.width()) / 2;
        this.offsetY = (this.field_22790 - Texture.SECRETS_BACKGROUND.height()) / 2;
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.secrets.close"), b -> this.method_25419()).method_46433(this.offsetX + 50, this.offsetY - 21).method_46437(250, 20).method_46431());
        this.populateSecrets();
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.SECRETS_BACKGROUND, this.offsetX, this.offsetY);
        FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.secrets.warning")), this.offsetX + 75, this.offsetX + 275, this.offsetY - 42, this.offsetY - 22, 200.0f, CommonColors.RED, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.OUTLINE);
        this.renderSecrets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScroll(guiGraphics);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX + 336, this.offsetX + 336 + Texture.SCROLL_BUTTON.width(), (int)this.scrollY, (int)(this.scrollY + (float)Texture.SCROLL_BUTTON.height()))) {
            this.draggingScroll = true;
            return true;
        }
        for (SecretInputWidget secretInput : this.secretInputs) {
            if (!secretInput.method_25405(mouseX, mouseY)) continue;
            return secretInput.method_25402(mouseX, mouseY, button);
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = this.offsetY + 7 + 17;
            int scrollAreaHeight = 121 - Texture.SCROLL_BUTTON.height();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        for (SecretInputWidget secretInput : this.secretInputs) {
            if (!secretInput.method_25405(mouseX, mouseY)) continue;
            return secretInput.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        for (SecretInputWidget secretInput : this.secretInputs) {
            if (!secretInput.method_25405(mouseX, mouseY)) continue;
            return secretInput.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        int scrollAmount = (int)(-deltaY * 10.0);
        int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.getMaxScrollOffset()));
        this.scroll(newOffset);
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    private void populateSecrets() {
        this.secretInputs = new ArrayList<SecretInputWidget>();
        int renderX = this.offsetX + 9;
        int renderY = this.offsetY + 10;
        for (WynntilsSecret wynntilsSecret : WynntilsSecret.values()) {
            SecretInputWidget secretInputWidget = new SecretInputWidget(renderX, renderY, 322, 20, this, wynntilsSecret);
            this.secretInputs.add(secretInputWidget);
            renderY += 22;
        }
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
        int currentY = this.offsetY + 10;
        for (class_339 class_3392 : this.secretInputs) {
            int newY = currentY - this.scrollOffset;
            class_3392.method_46419(newY);
            class_3392.field_22764 = newY <= this.offsetY + 10 + 135 && newY + class_3392.method_25364() >= this.offsetY + 10;
            currentY += 22;
        }
    }

    private int getMaxScrollOffset() {
        return (this.secretInputs.size() - 6) * 22;
    }

    private void renderSecrets(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.enableScissor(guiGraphics, this.offsetX + 9, this.offsetY + 8, 322, 134);
        this.secretInputs.forEach(secretInput -> secretInput.method_25394(guiGraphics, mouseX, mouseY, partialTick));
        RenderUtils.disableScissor(guiGraphics);
    }

    private void renderScroll(class_332 guiGraphics) {
        this.scrollY = (float)(this.offsetY + 7) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 135 - Texture.SCROLL_BUTTON.height());
        RenderUtils.drawTexturedRect(guiGraphics.method_51448(), Texture.SCROLL_BUTTON, this.offsetX + 336, this.scrollY);
    }
}

