/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemweight;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wynntils.core.components.Service;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.gear.type.ItemWeightSource;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.services.itemweight.type.ItemWeighting;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.type.Pair;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class ItemWeightService
extends Service {
    private static final class_2960 PILL_FONT = class_2960.method_60656((String)"banner/pill");
    private static final CustomColor NORI_COLOR = CustomColor.fromInt(1881596);
    private static final CustomColor WYNNPOOL_COLOR = CustomColor.fromInt(16553728);
    private static final class_2583 NORI_STYLE = class_2583.field_24360.method_27704(PILL_FONT).method_36139(NORI_COLOR.asInt());
    private static final class_2583 WYNNPOOL_STYLE = class_2583.field_24360.method_27704(PILL_FONT).method_36139(WYNNPOOL_COLOR.asInt());
    public static final class_2561 NORI_HEADER = class_2561.method_43470((String)"\ue060\udaff\udfff\ue03d\udaff\udfff\ue03e\udaff\udfff\ue041\udaff\udfff\ue038\udaff\udfff\ue062").method_27696(NORI_STYLE);
    public static final class_2561 WYNNPOOL_HEADER = class_2561.method_43470((String)"\ue060\udaff\udfff\ue046\udaff\udfff\ue048\udaff\udfff\ue03d\udaff\udfff\ue03d\udaff\udfff\ue03f\udaff\udfff\ue03e\udaff\udfff\ue03e\udaff\udfff\ue03b\udaff\udfff\ue062").method_27696(WYNNPOOL_STYLE);
    private final Map<ItemWeightSource, Map<String, List<ItemWeighting>>> weightings = new HashMap<ItemWeightSource, Map<String, List<ItemWeighting>>>();

    public ItemWeightService() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_ATHENA_ITEM_WEIGHTS).handleReader(this::handleItemWeights);
    }

    public List<ItemWeighting> getItemWeighting(String itemName, ItemWeightSource source) {
        if (!source.isSingleSource()) {
            return List.of();
        }
        return this.weightings.getOrDefault((Object)source, Map.of()).getOrDefault(itemName, List.of());
    }

    public float calculateWeighting(ItemWeighting weighting, IdentifiableItemProperty<?, ?> itemInfo) {
        if (weighting == null || itemInfo == null) {
            return 0.0f;
        }
        List<StatActualValue> identifications = itemInfo.getIdentifications();
        List<StatPossibleValues> possibleValues = itemInfo.getPossibleValues();
        if (identifications == null || possibleValues == null) {
            return 0.0f;
        }
        double weightedSum = 0.0;
        double sumWeights = 0.0;
        for (Map.Entry<String, Double> entry : weighting.identifications().entrySet()) {
            String statApiName = entry.getKey();
            double statWeight = entry.getValue();
            StatActualValue currentValue = identifications.stream().filter(id -> id.statType().getApiName().equalsIgnoreCase(statApiName)).findFirst().orElse(null);
            StatPossibleValues statPossibleValues = possibleValues.stream().filter(id -> id.statType().getApiName().equalsIgnoreCase(statApiName)).findFirst().orElse(null);
            if (currentValue == null || statPossibleValues == null) continue;
            double percent = StatCalculator.getPercentage(currentValue, statPossibleValues);
            if (statWeight < 0.0) {
                percent = 100.0 - percent;
            }
            weightedSum += percent * Math.abs(statWeight);
            sumWeights += Math.abs(statWeight);
        }
        if (sumWeights == 0.0) {
            return 0.0f;
        }
        return (float)(weightedSum / sumWeights);
    }

    public Map<StatType, Pair<Float, Float>> getStatWeights(ItemWeighting weighting, IdentifiableItemProperty<?, ?> itemInfo) {
        if (weighting == null || itemInfo == null) {
            return Map.of();
        }
        LinkedHashMap<StatType, Pair<Float, Float>> statWeights = new LinkedHashMap<StatType, Pair<Float, Float>>();
        for (Map.Entry<String, Double> entry : weighting.identifications().entrySet()) {
            String statApiName = entry.getKey();
            float statWeight = entry.getValue().floatValue() * 100.0f;
            List<StatActualValue> identifications = itemInfo.getIdentifications();
            List<StatPossibleValues> possibleValues = itemInfo.getPossibleValues();
            StatActualValue currentValue = identifications.stream().filter(id -> id.statType().getApiName().equalsIgnoreCase(statApiName)).findFirst().orElse(null);
            StatPossibleValues statPossibleValues = possibleValues.stream().filter(id -> id.statType().getApiName().equalsIgnoreCase(statApiName)).findFirst().orElse(null);
            if (currentValue == null || statPossibleValues == null) continue;
            float percent = StatCalculator.getPercentage(currentValue, statPossibleValues);
            statWeights.put(currentValue.statType(), Pair.of(Float.valueOf(statWeight), Float.valueOf(percent)));
        }
        return statWeights;
    }

    private void handleItemWeights(Reader reader) {
        JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        for (ItemWeightSource source : ItemWeightSource.values()) {
            String sourceName;
            if (!source.isSingleSource() || !jsonObject.has(sourceName = source.name().toLowerCase(Locale.ROOT))) continue;
            this.parseWeightingGroup(jsonObject.getAsJsonObject(sourceName), source);
        }
    }

    private void parseWeightingGroup(JsonObject group, ItemWeightSource source) {
        Map sourceMap = this.weightings.computeIfAbsent(source, s -> new HashMap());
        for (Map.Entry itemEntry : group.entrySet()) {
            String itemName = (String)itemEntry.getKey();
            JsonObject weights = ((JsonElement)itemEntry.getValue()).getAsJsonObject();
            List itemWeights = sourceMap.computeIfAbsent(itemName, k -> new ArrayList());
            for (Map.Entry weightEntry : weights.entrySet()) {
                String weightName = (String)weightEntry.getKey();
                JsonObject identificationsObj = ((JsonElement)weightEntry.getValue()).getAsJsonObject();
                Map identifications = identificationsObj.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingDouble(JsonElement::getAsDouble).reversed())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsDouble(), (a, b) -> a, LinkedHashMap::new));
                itemWeights.add(new ItemWeighting(weightName, identifications));
            }
        }
    }
}

