/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.leaderboard.type;

public enum LeaderboardType {
    WOODCUTTING("woodcuttingLevel"),
    MINING("miningLevel"),
    FISHING("fishingLevel"),
    FARMING("farmingLevel"),
    ALCHEMISM("alchemismLevel"),
    ARMOURING("armouringLevel"),
    COOKING("cookingLevel"),
    JEWELING("jewelingLevel"),
    SCRIBING("scribingLevel"),
    TAILORING("tailoringLevel"),
    WEAPONSMITHING("weaponsmithingLevel"),
    WOODWORKING("woodworkingLevel"),
    PROFESSIONS_GLOBAL("professionsGlobalLevel"),
    PROFESSIONS_SOLO("professionsSoloLevel"),
    COMBAT_GLOBAL("combatGlobalLevel"),
    COMBAT_SOLO("combatSoloLevel"),
    TOTAL_GLOBAL("totalGlobalLevel"),
    TOTAL_SOLO("totalSoloLevel"),
    CONTENT_GLOBAL("globalPlayerContent"),
    CONTENT_SOLO("playerContent"),
    NOG_SCORE("grootslangSrPlayers"),
    NOG_COMPLETION("grootslangCompletion"),
    NOL_SCORE("orphionSrPlayers"),
    NOL_COMPLETION("orphionCompletion"),
    TCC_SCORE("colossusSrPlayers"),
    TCC_COMPLETION("colossusCompletion"),
    TNA_SCORE("namelessSrPlayers"),
    TNA_COMPLETION("namelessCompletion"),
    IRONMAN("ironmanContent"),
    ULTIMATE_IRONMAN("ultimateIronmanContent"),
    HARDCORE("hardcoreContent"),
    CRAFTSMAN("craftsmanContent"),
    HUNTED("huntedContent"),
    HUIC("huicContent"),
    HUICH("huichContent"),
    HICH("hichContent"),
    HIC("hicContent"),
    WARS("warsCompletion"),
    HARDCORE_LEGACY_LEVEL("hardcoreLegacyLevel"),
    GUILD_LEVEL("guildLevel", true),
    GUILD_TERRITORIES("guildTerritories", true),
    GUILD_WARS("guildWars", true),
    GUILD_NOG("grootslangSrGuilds", true),
    GUILD_NOL("orphionSrGuilds", true),
    GUILD_TCC("colossusSrGuilds", true),
    GUILD_TNA("namelessSrGuilds", true);

    private final String key;
    private final boolean guildLeaderboard;

    private LeaderboardType(String key, boolean guildLeaderboard) {
        this.key = key;
        this.guildLeaderboard = guildLeaderboard;
    }

    private LeaderboardType(String key) {
        this(key, false);
    }

    public String getKey() {
        return this.key;
    }

    public static LeaderboardType fromKey(String key) {
        for (LeaderboardType type : LeaderboardType.values()) {
            if (!type.getKey().equals(key)) continue;
            return type;
        }
        return null;
    }

    public boolean isGuildLeaderboard() {
        return this.guildLeaderboard;
    }
}

