/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.statistics;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Service;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.services.statistics.StatisticsCollectors;
import com.wynntils.services.statistics.type.StatisticEntry;
import com.wynntils.services.statistics.type.StatisticKind;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.neoforged.bus.api.SubscribeEvent;

public final class StatisticsService
extends Service {
    private final StatisticsCollectors collectors = new StatisticsCollectors();
    @Persisted
    private final Storage<Map<String, Map<StatisticKind, StatisticEntry>>> statistics = new Storage(new TreeMap());
    @Persisted
    public final Storage<Boolean> screenOverallMode = new Storage<Boolean>(true);
    private Map<StatisticKind, StatisticEntry> currentStatistics = new EnumMap<StatisticKind, StatisticEntry>(StatisticKind.class);

    public StatisticsService() {
        super(List.of());
        WynntilsMod.registerEventListener(this.collectors);
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent event) {
        if (!Models.Character.hasCharacter()) {
            this.currentStatistics = new EnumMap<StatisticKind, StatisticEntry>(StatisticKind.class);
            return;
        }
        this.setCurrentStatistics(Models.Character.getId());
    }

    @SubscribeEvent
    public void onCharacterUpdated(CharacterUpdateEvent event) {
        this.setCurrentStatistics(Models.Character.getId());
    }

    public void increaseStatistics(StatisticKind kind) {
        this.addToStatistics(kind, 1L);
    }

    public void addToStatistics(StatisticKind kind, long amount) {
        StatisticEntry newValue = this.currentStatistics.containsKey((Object)kind) ? this.currentStatistics.get((Object)kind).getUpdatedEntry(amount) : new StatisticEntry(amount, 1L, amount, amount, System.currentTimeMillis(), System.currentTimeMillis());
        this.currentStatistics.put(kind, newValue);
        this.statistics.touched();
    }

    public StatisticEntry getStatistic(StatisticKind statistic) {
        return this.currentStatistics.getOrDefault((Object)statistic, StatisticEntry.EMPTY);
    }

    public Map<StatisticKind, StatisticEntry> getStatistics() {
        return this.currentStatistics;
    }

    public StatisticEntry getOverallStatistic(StatisticKind statistic) {
        StatisticEntry overall = StatisticEntry.EMPTY;
        for (Map characterStatistics : ((Map)this.statistics.get()).values()) {
            StatisticEntry entry = (StatisticEntry)characterStatistics.get((Object)statistic);
            if (entry == null) continue;
            overall = new StatisticEntry(overall.total() + entry.total(), overall.count() + entry.count(), Math.min(overall.min(), entry.min()), Math.max(overall.max(), entry.max()), Math.min(overall.firstModified(), entry.firstModified()), Math.max(overall.lastModified(), entry.lastModified()));
        }
        return overall;
    }

    public void resetStatisticForCharacter(StatisticKind statistic) {
        this.currentStatistics.remove((Object)statistic);
        this.statistics.touched();
    }

    public void resetStatisticOverall(StatisticKind statistic) {
        for (Map characterStatistics : ((Map)this.statistics.get()).values()) {
            characterStatistics.remove((Object)statistic);
        }
        this.statistics.touched();
    }

    public void resetStatistics() {
        this.currentStatistics.clear();
        this.statistics.touched();
    }

    private void setCurrentStatistics(String id) {
        ((Map)this.statistics.get()).putIfAbsent(id, new EnumMap(StatisticKind.class));
        this.currentStatistics = (Map)((Map)this.statistics.get()).get(id);
        this.statistics.touched();
    }

    public void init() {
        for (StatisticKind kind : StatisticKind.values()) {
            assert (!kind.getName().startsWith("statistics.wynntils.")) : "Fix i18n for " + kind.getName();
        }
    }
}

