/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.type;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;

public final class ThrottledSupplier<T>
implements Supplier<T> {
    private final Supplier<T> method;
    private final Duration cooldown;
    private T current;
    private Instant lastExecutionTime = Instant.EPOCH;

    public ThrottledSupplier(Supplier<T> method, Duration cooldown) {
        this.method = method;
        this.cooldown = cooldown;
    }

    @Override
    public T get() {
        Duration difference = Duration.between(this.lastExecutionTime, Instant.now());
        if (difference.minus(this.cooldown).isNegative()) {
            return this.current;
        }
        this.lastExecutionTime = Instant.now();
        this.current = this.method.get();
        return this.current;
    }
}

