/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.antiope.core;

import com.wynntils.antiope.core.type.CoreClosedException;
import com.wynntils.antiope.core.type.CreateParams;
import com.wynntils.antiope.core.type.GameSDKException;
import com.wynntils.antiope.core.type.LogLevel;
import com.wynntils.antiope.core.type.Result;
import com.wynntils.antiope.manager.activity.ActivityManager;
import com.wynntils.antiope.manager.overlay.OverlayManager;
import com.wynntils.antiope.util.FileUtils;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DiscordGameSDKCore
implements AutoCloseable {
    private static final String JNI_LIBRARY_NAME = "discord_game_sdk_jni";
    private static final String DISCORD_LIBRARY_NAME = "discord_game_sdk";
    private static boolean firstInitDone = false;
    public static final Consumer<Result> DEFAULT_CALLBACK = result -> {
        if (result != Result.OK) {
            throw new GameSDKException((Result)((Object)result));
        }
    };
    public static final BiConsumer<LogLevel, String> DEFAULT_LOG_HOOK = (level, message) -> System.out.printf("[%s] %s\n", level, message);
    private final long pointer;
    private final CreateParams createParams;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final ReentrantLock lock = new ReentrantLock();
    private final ActivityManager activityManager;
    private final OverlayManager overlayManager;

    public static void loadLibrary() {
        boolean preloadDiscordSdk;
        String discordSdkName;
        String jniLibraryName;
        String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ROOT);
        if (osName.contains("windows")) {
            osName = "windows";
            jniLibraryName = "discord_game_sdk_jni.dll";
            discordSdkName = "discord_game_sdk.dll";
            preloadDiscordSdk = true;
        } else if (osName.contains("linux")) {
            osName = "linux";
            jniLibraryName = "libdiscord_game_sdk_jni.so";
            discordSdkName = "discord_game_sdk.so";
            preloadDiscordSdk = false;
        } else if (osName.contains("mac os")) {
            osName = "macos";
            jniLibraryName = "libdiscord_game_sdk_jni.dylib";
            discordSdkName = "discord_game_sdk.dylib";
            preloadDiscordSdk = false;
        } else {
            throw new RuntimeException("Cannot determine OS type: " + osName);
        }
        if (arch.equals("amd64")) {
            arch = "x86_64";
        }
        String discordSdkPath = "/discord_game_sdk/lib/" + arch + "/" + discordSdkName;
        File discordSdkFile = FileUtils.createTemporaryFileFromResource(discordSdkPath);
        if (preloadDiscordSdk) {
            System.load(discordSdkFile.getAbsolutePath());
        }
        if (arch.equals("x86_64")) {
            arch = "amd64";
        }
        String jniPath = "/native/" + osName + "/" + arch + "/" + jniLibraryName;
        File jniFile = FileUtils.createTemporaryFileFromResource(jniPath);
        System.load(jniFile.getAbsolutePath());
        DiscordGameSDKCore.initDiscordNative(discordSdkFile.getAbsolutePath());
        firstInitDone = true;
    }

    private static native void initDiscordNative(String var0);

    public DiscordGameSDKCore(CreateParams params) {
        if (!firstInitDone) {
            throw new IllegalStateException("Tried to create Core before calling Core.loadLibrary()");
        }
        this.createParams = params;
        Object ret = this.create(params.getPointer());
        if (ret instanceof Result) {
            throw new GameSDKException((Result)((Object)ret));
        }
        this.pointer = (Long)ret;
        this.setLogHook(LogLevel.WARN, DEFAULT_LOG_HOOK);
        this.activityManager = new ActivityManager(this.getActivityManager(this.pointer), this);
        this.overlayManager = new OverlayManager(this.getOverlayManager(this.pointer), this);
    }

    private native Object create(long var1);

    private native void destroy(long var1);

    private native long getActivityManager(long var1);

    private native long getOverlayManager(long var1);

    private native void runCallbacks(long var1);

    private native void setLogHook(long var1, int var3, BiConsumer<LogLevel, String> var4);

    public ActivityManager activityManager() {
        return this.activityManager;
    }

    public OverlayManager overlayManager() {
        return this.overlayManager;
    }

    public void runCallbacks() {
        this.execute(() -> this.runCallbacks(this.pointer));
    }

    public void setLogHook(LogLevel minLevel, BiConsumer<LogLevel, String> logHook) {
        this.execute(() -> this.setLogHook(this.pointer, minLevel.ordinal(), Objects.requireNonNull(logHook)));
    }

    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            this.lock.lock();
            try {
                this.destroy(this.pointer);
            }
            finally {
                this.lock.unlock();
            }
            this.createParams.close();
        }
    }

    public long getPointer() {
        return this.pointer;
    }

    public <T> T execute(Supplier<T> provider) {
        if (!this.isOpen()) {
            throw new CoreClosedException();
        }
        this.lock.lock();
        try {
            T t = provider.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void execute(Runnable runnable) {
        this.execute(() -> {
            runnable.run();
            return null;
        });
    }
}

