/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.commands.LocateCommand;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.features.map.WorldWaypointDistanceFeature;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.services.map.pois.LabelPoi;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.pois.ServicePoi;
import com.wynntils.services.map.type.ServiceKind;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.wynn.LocationUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CompassCommand
extends Command {
    private static final SuggestionProvider<class_2168> SHARE_TARGET_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Stream.concat(Stream.of("party", "guild"), McUtils.mc().field_1687.method_18456().stream().map(class_1657::method_5820)), (SuggestionsBuilder)builder);
    public static final SuggestionProvider<class_2168> TERRITORY_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Models.Territory.getTerritoryNames(), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "compass";
    }

    @Override
    public List<String> getAliases() {
        return List.of("c", "comp");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(class_2170.method_9247((String)"at").then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(this::compassAtVec3)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"share").then(class_2170.method_9247((String)"location").then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.word()).suggests(SHARE_TARGET_SUGGESTION_PROVIDER).executes(this::shareLocation)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.word()).suggests(SHARE_TARGET_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(this::shareCompassIndex))).executes(this::shareCompass)))).then(class_2170.method_9247((String)"service").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(LocateCommand.SERVICE_SUGGESTION_PROVIDER).executes(this::compassService)))).then(class_2170.method_9247((String)"place").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests(LocateCommand.PLACES_SUGGESTION_PROVIDER).executes(this::compassPlace)))).then(class_2170.method_9247((String)"territory").then(class_2170.method_9244((String)"territory", (ArgumentType)StringArgumentType.greedyString()).suggests(TERRITORY_SUGGESTION_PROVIDER).executes(this::territory)))).then(class_2170.method_9247((String)"npc").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::notImplemented)))).then(class_2170.method_9247((String)"other").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::notImplemented)))).then(class_2170.method_9247((String)"clear").executes(this::compassClear))).then(class_2170.method_9244((String)"location", (ArgumentType)StringArgumentType.greedyString()).executes(this::compassAtString))).executes(this::syntaxError);
    }

    private int shareCompassIndex(CommandContext<class_2168> context) {
        List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
        if (markers.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have a compass set!").method_27692(class_124.field_1061));
            return 1;
        }
        String target = StringArgumentType.getString(context, (String)"target");
        int index = IntegerArgumentType.getInteger(context, (String)"index");
        LocationUtils.shareCompass(target, markers.get(index).location());
        return 1;
    }

    private int shareCompass(CommandContext<class_2168> context) {
        List<MarkerInfo> markers = MarkerModel.USER_WAYPOINTS_PROVIDER.getMarkerInfos().toList();
        if (markers.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have a compass set!").method_27692(class_124.field_1061));
            return 1;
        }
        String target = StringArgumentType.getString(context, (String)"target");
        LocationUtils.shareCompass(target, markers.getFirst().location());
        return 1;
    }

    private int shareLocation(CommandContext<class_2168> context) {
        String target = StringArgumentType.getString(context, (String)"target");
        LocationUtils.shareLocation(target);
        return 1;
    }

    private int compassAtVec3(CommandContext<class_2168> context) {
        class_2267 coordinates = class_2277.method_9734(context, (String)"location");
        Location location = new Location(coordinates.method_9704((class_2168)context.getSource()));
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(location, null);
        class_5250 response = class_2561.method_43470((String)"Compass set to ").method_27692(class_124.field_1075);
        response.method_10852((class_2561)class_2561.method_43470((String)location.toString()).method_27692(class_124.field_1068));
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int compassAtString(CommandContext<class_2168> context) {
        String coordinates = StringArgumentType.getString(context, (String)"location");
        Optional<Location> location = LocationUtils.parseFromString(coordinates);
        if (location.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Incorrect coordinates!"));
            return 0;
        }
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(location.get(), null);
        class_5250 response = class_2561.method_43470((String)"Compass set to ").method_27692(class_124.field_1075);
        response.method_10852((class_2561)class_2561.method_43470((String)location.get().toString()).method_27692(class_124.field_1068));
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int compassService(CommandContext<class_2168> context) {
        String searchedName = (String)context.getArgument("name", String.class);
        ServiceKind selectedKind = LocateCommand.getServiceKind(context, searchedName);
        if (selectedKind == null) {
            return 0;
        }
        class_243 currentLocation = McUtils.player().method_19538();
        Optional<ServicePoi> closestServiceOptional = Services.Poi.getServicePois().filter(poi -> poi.getKind() == selectedKind).min(Comparator.comparingDouble(poi -> currentLocation.method_1028((double)poi.getLocation().getX(), (double)poi.getLocation().getY().orElse((int)currentLocation.field_1351).intValue(), (double)poi.getLocation().getZ())));
        if (closestServiceOptional.isEmpty()) {
            class_5250 response = class_2561.method_43470((String)("Found no services of kind '" + selectedKind.getName() + "'")).method_27692(class_124.field_1061);
            ((class_2168)context.getSource()).method_9213((class_2561)response);
            return 0;
        }
        Poi closestService = closestServiceOptional.get();
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(closestService.getLocation().asLocation(), closestServiceOptional.get().getIcon(), (Boolean)Managers.Feature.getFeatureInstance(WorldWaypointDistanceFeature.class).showAdditionalTextInWorld.get() != false ? closestServiceOptional.get().getName() : null);
        class_5250 response = class_2561.method_43470((String)("Compass set to " + selectedKind.getName() + " at ")).method_27692(class_124.field_1075);
        response.method_10852((class_2561)class_2561.method_43470((String)closestService.getLocation().toString()).method_27692(class_124.field_1068));
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int compassPlace(CommandContext<class_2168> context) {
        Poi place;
        String searchedName = (String)context.getArgument("name", String.class);
        ArrayList<LabelPoi> places = new ArrayList<LabelPoi>(Services.Poi.getLabelPois().filter(poi -> StringUtils.partialMatch(poi.getName(), searchedName)).toList());
        if (places.isEmpty()) {
            class_5250 response = class_2561.method_43470((String)("Found no places matching '" + searchedName + "'")).method_27692(class_124.field_1061);
            ((class_2168)context.getSource()).method_9213((class_2561)response);
            return 0;
        }
        if (places.size() > 1) {
            Optional<Poi> exactMatch = places.stream().filter(poi -> poi.getName().equals(searchedName)).findFirst();
            if (exactMatch.isEmpty()) {
                class_5250 response = class_2561.method_43470((String)("Found multiple places matching '" + searchedName + "', but none matched exactly. Matching: ")).method_27692(class_124.field_1061);
                response.method_10852((class_2561)class_2561.method_43470((String)String.join((CharSequence)", ", places.stream().map(Poi::getName).toList())));
                ((class_2168)context.getSource()).method_9213((class_2561)response);
                return 0;
            }
            place = exactMatch.get();
        } else {
            place = (Poi)places.getFirst();
        }
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(place.getLocation().asLocation(), place.getName());
        class_5250 response = class_2561.method_43470((String)("Compass set to " + place.getName() + " at ")).method_27692(class_124.field_1075);
        response.method_10852((class_2561)class_2561.method_43470((String)place.getLocation().toString()).method_27692(class_124.field_1068));
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    public int territory(CommandContext<class_2168> context) {
        String territoryArg = (String)context.getArgument("territory", String.class);
        TerritoryProfile territoryProfile = Models.Territory.getTerritoryProfile(territoryArg);
        if (territoryProfile == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Can't find territory '" + territoryArg + "'")).method_27692(class_124.field_1061));
            return 1;
        }
        PoiLocation location = territoryProfile.getCenterLocation();
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(location.asLocation(), null);
        class_5250 response = class_2561.method_43470((String)("Compass set to middle of " + territoryProfile.getFriendlyName() + " at ")).method_27692(class_124.field_1075);
        response.method_10852((class_2561)class_2561.method_43470((String)location.toString()).method_27692(class_124.field_1068));
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int compassClear(CommandContext<class_2168> context) {
        MarkerModel.USER_WAYPOINTS_PROVIDER.removeAllLocations();
        class_5250 response = class_2561.method_43470((String)"Compass cleared").method_27692(class_124.field_1075);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int notImplemented(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Not implemented yet").method_27692(class_124.field_1061));
        return 0;
    }

    public int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }
}

