/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.screens.base.WynntilsMenuScreenBase;
import com.wynntils.screens.lootrunpaths.WynntilsLootrunPathsScreen;
import com.wynntils.services.lootrunpaths.LootrunPathsService;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.services.lootrunpaths.type.LootrunSaveResult;
import com.wynntils.services.lootrunpaths.type.LootrunState;
import com.wynntils.services.lootrunpaths.type.LootrunUndoResult;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.PosUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2178;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class LootrunCommand
extends Command {
    private static final SuggestionProvider<class_2168> LOOTRUN_SUGGESTION_PROVIDER = (context, suggestions) -> class_2172.method_9264(Stream.of(LootrunPathsService.LOOTRUNS.list()).map(name -> name.replaceAll("\\.json$", "")).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)suggestions);

    @Override
    public String getCommandName() {
        return "lootrun";
    }

    @Override
    public List<String> getAliases() {
        return List.of("lr");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(class_2170.method_9247((String)"load").then(class_2170.method_9244((String)"lootrun", (ArgumentType)StringArgumentType.string()).suggests(LOOTRUN_SUGGESTION_PROVIDER).executes(this::loadLootrun)))).then(class_2170.method_9247((String)"record").executes(this::recordLootrun))).then(class_2170.method_9247((String)"save").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::saveLootrun)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"note").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(class_2170.method_9247((String)"json").then(class_2170.method_9244((String)"text", (ArgumentType)class_2178.method_9281((class_7157)context)).executes(this::addJsonLootrunNote)))).then(class_2170.method_9247((String)"text").then(class_2170.method_9244((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(this::addTextLootrunNote))))).then(class_2170.method_9247((String)"list").executes(this::listLootrunNote))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(this::deleteLootrunNote))))).then(class_2170.method_9247((String)"clear").executes(this::clearLootrun))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests(LOOTRUN_SUGGESTION_PROVIDER).executes(this::deleteLootrun)))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"old", (ArgumentType)StringArgumentType.string()).suggests(LOOTRUN_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"new", (ArgumentType)StringArgumentType.string()).executes(this::renameLootrun))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"chest").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(this::addChest)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(this::removeChest))))).then(class_2170.method_9247((String)"undo").executes(this::undoLootrun))).then(class_2170.method_9247((String)"folder").executes(this::folderLootrun))).then(class_2170.method_9247((String)"screen").executes(this::screenLootrun))).executes(this::syntaxError);
    }

    private int loadLootrun(CommandContext<class_2168> context) {
        String fileName = StringArgumentType.getString(context, (String)"lootrun");
        Services.LootrunPaths.tryLoadLootrun(fileName);
        return 1;
    }

    private int recordLootrun(CommandContext<class_2168> context) {
        if (Services.LootrunPaths.getState() != LootrunState.RECORDING) {
            Services.LootrunPaths.startRecording();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.lootrun.recordStart", (Object[])new Object[]{class_2561.method_43470((String)"/lootrun record").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/lootrun record")))}), false);
        } else {
            Services.LootrunPaths.stopRecording();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.lootrun.recordStop1", (Object[])new Object[]{class_2561.method_43470((String)"/lootrun clear").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/lootrun clear")))}).method_27692(class_124.field_1061).method_27693("\n").method_10852((class_2561)class_2561.method_43469((String)"command.wynntils.lootrun.recordStop2", (Object[])new Object[]{class_2561.method_43470((String)"/lootrun save <name>").method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/lootrun save ")))}).method_27692(class_124.field_1060)), false);
        }
        return 1;
    }

    private int saveLootrun(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        LootrunSaveResult lootrunSaveResult = Services.LootrunPaths.saveCurrentLootrun(name);
        if (lootrunSaveResult == null) {
            return 0;
        }
        switch (lootrunSaveResult) {
            case SAVED: {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.lootrun.savedLootrun").method_27692(class_124.field_1060), false);
                return 1;
            }
            case ERROR_SAVING: {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.wynntils.lootrun.errorSavingLootrun").method_27692(class_124.field_1061));
                return 0;
            }
            case ERROR_ALREADY_EXISTS: {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.wynntils.lootrun.errorSavingLootrunAlreadyExists").method_27692(class_124.field_1061));
                return 0;
            }
        }
        return 0;
    }

    private int addJsonLootrunNote(CommandContext<class_2168> context) {
        class_2561 text = class_2178.method_9280(context, (String)"text");
        class_1297 root = McUtils.player().method_5668();
        class_2338 pos = root.method_24515();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.lootrun.addedNote", (Object[])new Object[]{pos.method_23854()}).method_27693("\n" + String.valueOf(text)), false);
        return Services.LootrunPaths.addNote(text);
    }

    private int addTextLootrunNote(CommandContext<class_2168> context) {
        class_5250 text = class_2561.method_43470((String)StringArgumentType.getString(context, (String)"text"));
        class_1297 root = McUtils.player().method_5668();
        class_2338 pos = root.method_24515();
        ((class_2168)context.getSource()).method_9226(() -> LootrunCommand.lambda$addTextLootrunNote$9(pos, (class_2561)text), false);
        return Services.LootrunPaths.addNote((class_2561)text);
    }

    private int listLootrunNote(CommandContext<class_2168> context) {
        List<LootrunNote> notes = Services.LootrunPaths.getCurrentNotes();
        if (notes.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.wynntils.lootrun.listNoteNoNote"));
        } else {
            class_5250 component = class_2561.method_43471((String)"command.wynntils.lootrun.listNoteHeader");
            for (LootrunNote note : notes) {
                class_2338 pos = PosUtils.newBlockPos(note.position());
                String posString = pos.method_23854();
                component.method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)"[X]").method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"command.wynntils.lootrun.listClickToDelete"))).method_10958(new class_2558(class_2558.class_2559.field_11750, "/lootrun note delete " + posString.replace(",", ""))).method_10977(class_124.field_1061))).method_27693(" " + posString + ": ").method_10852(note.component());
            }
            ((class_2168)context.getSource()).method_9226(() -> component, false);
        }
        return 1;
    }

    private int deleteLootrunNote(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_9697(context, (String)"pos");
        LootrunNote removedNote = Services.LootrunPaths.deleteNoteAt(pos);
        if (removedNote != null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.lootrun.noteRemovedSuccessfully", (Object[])new Object[]{pos.method_23854(), removedNote.component()}).method_27692(class_124.field_1060), false);
        } else {
            String posString = pos.method_23854();
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.wynntils.lootrun.noteUnableToFind", (Object[])new Object[]{posString}));
        }
        return Services.LootrunPaths.recompileLootrun(true);
    }

    private int clearLootrun(CommandContext<class_2168> context) {
        if (Services.LootrunPaths.getState() == LootrunState.DISABLED) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.wynntils.lootrun.noActiveLootrun"));
            return 0;
        }
        Services.LootrunPaths.clearCurrentLootrun();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.lootrun.clearSuccessful").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int deleteLootrun(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        File file = new File(LootrunPathsService.LOOTRUNS, name + ".json");
        if (!file.exists()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.wynntils.lootrun.lootrunDoesntExist", (Object[])new Object[]{name}));
        } else {
            if (file.delete()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.lootrun.lootrunDeleted", (Object[])new Object[]{name}).method_27692(class_124.field_1060), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.wynntils.lootrun.lootrunCouldNotBeDeleted", (Object[])new Object[]{name}));
        }
        return 0;
    }

    private int renameLootrun(CommandContext<class_2168> context) {
        String oldName = StringArgumentType.getString(context, (String)"old");
        String newName = StringArgumentType.getString(context, (String)"new");
        File oldFile = new File(LootrunPathsService.LOOTRUNS, oldName + ".json");
        File newFile = new File(LootrunPathsService.LOOTRUNS, newName + ".json");
        if (!oldFile.exists()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.wynntils.lootrun.lootrunDoesntExist", (Object[])new Object[]{oldName}));
        } else {
            if (oldFile.renameTo(newFile)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.lootrun.lootrunRenamed", (Object[])new Object[]{oldName, newName}).method_27692(class_124.field_1060), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.wynntils.lootrun.lootrunCouldNotBeRenamed", (Object[])new Object[]{oldName, newName}));
        }
        return 0;
    }

    private int addChest(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_9697(context, (String)"pos");
        boolean successful = Services.LootrunPaths.addChest(pos);
        if (successful) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.lootrun.chestAdded", (Object[])new Object[]{pos.method_23854()}).method_27692(class_124.field_1060), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.wynntils.lootrun.chestAlreadyAdded", (Object[])new Object[]{pos.method_23854()}));
        }
        return Services.LootrunPaths.recompileLootrun(true);
    }

    private int removeChest(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos = class_2262.method_9697(context, (String)"pos");
        boolean successful = Services.LootrunPaths.removeChest(pos);
        if (successful) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.wynntils.lootrun.chestRemoved", (Object[])new Object[]{pos.method_23854()}).method_27692(class_124.field_1060), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.wynntils.lootrun.chestDoesNotExist", (Object[])new Object[]{pos.method_23854()}));
        }
        return Services.LootrunPaths.recompileLootrun(true);
    }

    private int undoLootrun(CommandContext<class_2168> context) {
        if (Services.LootrunPaths.getState() != LootrunState.RECORDING) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.wynntils.lootrun.notRecording"));
        } else {
            LootrunUndoResult lootrunUndoResult = Services.LootrunPaths.tryUndo();
            switch (lootrunUndoResult) {
                case SUCCESSFUL: {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.lootrun.undoSuccessful"), false);
                    return 1;
                }
                case ERROR_STAND_NEAR_POINT: {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.wynntils.lootrun.undoStandNear"));
                    return 0;
                }
                case ERROR_NOT_FAR_ENOUGH: {
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.wynntils.lootrun.undoNotFarEnough"));
                    return 0;
                }
            }
        }
        return 0;
    }

    private int folderLootrun(CommandContext<class_2168> context) {
        class_156.method_668().method_672(LootrunPathsService.LOOTRUNS);
        return 1;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }

    private int screenLootrun(CommandContext<class_2168> context) {
        Managers.TickScheduler.scheduleLater(() -> WynntilsMenuScreenBase.openBook(WynntilsLootrunPathsScreen.create()), 2);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$addTextLootrunNote$9(class_2338 pos, class_2561 text) {
        return class_2561.method_43469((String)"command.wynntils.lootrun.addedNote", (Object[])new Object[]{pos.method_23854()}).method_27693("\n" + String.valueOf(text));
    }
}

