/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.players.type.WynnPlayerInfo;
import com.wynntils.utils.DateFormatter;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class PlayerCommand
extends Command {
    private static final DateFormatter DATE_FORMATTER = new DateFormatter(true);
    private static final SuggestionProvider<class_2168> PLAYER_NAME_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Models.Player.getAllPlayerNames(), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "player";
    }

    @Override
    public List<String> getAliases() {
        return List.of("pl");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(class_2170.method_9247((String)"guild").then(class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.word()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).executes(this::lookupPlayerGuild)))).then(class_2170.method_9247((String)"g").then(class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.word()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).executes(this::lookupPlayerGuild)))).then(class_2170.method_9247((String)"lastseen").then(class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.word()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).executes(this::lookupPlayerLastSeen)))).then(class_2170.method_9247((String)"ls").then(class_2170.method_9244((String)"username", (ArgumentType)StringArgumentType.word()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).executes(this::lookupPlayerLastSeen)))).executes(this::syntaxError);
    }

    private int lookupPlayerGuild(CommandContext<class_2168> context) {
        CompletableFuture<WynnPlayerInfo> completableFuture = Models.Player.getPlayer((String)context.getArgument("username", String.class));
        completableFuture.whenComplete((player, throwable) -> {
            if (throwable != null) {
                McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)("Unable to view player guild for " + (String)context.getArgument("username", String.class))).method_27692(class_124.field_1061));
                WynntilsMod.error("Error trying to parse player guild", throwable);
            } else {
                if (player == null) {
                    McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)("Unknown player " + (String)context.getArgument("username", String.class))).method_27692(class_124.field_1061));
                    return;
                }
                class_5250 response = class_2561.method_43470((String)player.username()).method_27692(class_124.field_1062);
                if (player.guildName() != null) {
                    response.method_10852((class_2561)class_2561.method_43470((String)" is a ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)player.guildRank().getGuildDescription()).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)" of ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(player.guildName() + " [" + player.guildPrefix() + "]")).method_27692(class_124.field_1075)))));
                    if (player.guildJoinTimestamp() != null) {
                        long differenceInMillis = System.currentTimeMillis() - player.guildJoinTimestamp().toEpochMilli();
                        response.method_10852((class_2561)class_2561.method_43470((String)"\nThey have been in the guild for ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)DATE_FORMATTER.format(differenceInMillis)).method_27692(class_124.field_1075)));
                    }
                } else {
                    response.method_10852((class_2561)class_2561.method_43470((String)" is not in a guild").method_27692(class_124.field_1080));
                }
                McUtils.sendMessageToClient((class_2561)response);
            }
        });
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.player.lookingUp").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int lookupPlayerLastSeen(CommandContext<class_2168> context) {
        CompletableFuture<WynnPlayerInfo> completableFuture = Models.Player.getPlayer((String)context.getArgument("username", String.class));
        completableFuture.whenComplete((player, throwable) -> {
            if (throwable != null) {
                McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)("Unable to view player last seen for " + (String)context.getArgument("username", String.class))).method_27692(class_124.field_1061));
                WynntilsMod.error("Error trying to parse player last seen", throwable);
            } else {
                if (player == null) {
                    McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)("Unknown player " + (String)context.getArgument("username", String.class))).method_27692(class_124.field_1061));
                    return;
                }
                class_5250 response = class_2561.method_43470((String)player.username()).method_27692(class_124.field_1075);
                if (player.online()) {
                    response.method_10852((class_2561)class_2561.method_43470((String)" is online on ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)player.server()).method_27692(class_124.field_1065)));
                } else {
                    long differenceInMillis = System.currentTimeMillis() - player.lastJoinTimestamp().toEpochMilli();
                    response.method_10852((class_2561)class_2561.method_43470((String)" was last seen ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)DATE_FORMATTER.format(differenceInMillis)).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"ago").method_27692(class_124.field_1080)));
                }
                McUtils.sendMessageToClient((class_2561)response);
            }
        });
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.player.lookingUp").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }
}

