/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.wynntils.commands.BombBellCommand;
import com.wynntils.commands.CompassCommand;
import com.wynntils.commands.ConfigCommand;
import com.wynntils.commands.FeatureCommand;
import com.wynntils.commands.FunctionCommand;
import com.wynntils.commands.LocateCommand;
import com.wynntils.commands.LootrunCommand;
import com.wynntils.commands.MapCommand;
import com.wynntils.commands.OnlineMembersCommand;
import com.wynntils.commands.PlayerCommand;
import com.wynntils.commands.ServersCommand;
import com.wynntils.commands.StatisticsCommand;
import com.wynntils.commands.TerritoryCommand;
import com.wynntils.commands.WynntilsCommand;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.consumers.commands.ClientCommandSourceStack;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.mc.event.CommandsAddedEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_746;
import net.neoforged.bus.api.SubscribeEvent;

public final class ClientCommandManager
extends Manager {
    private final CommandDispatcher<class_2168> clientDispatcher = new CommandDispatcher();
    private final List<Command> commandInstanceSet = new ArrayList<Command>();
    private WynntilsCommand wynntilsCommand;

    public ClientCommandManager() {
        super(List.of());
        this.registerAllCommands();
    }

    @SubscribeEvent
    public void onCommandsAdded(CommandsAddedEvent event) {
        class_7157 context = event.getContext();
        for (Command command : this.commandInstanceSet) {
            command.getCommandBuilders(context).forEach(arg_0 -> this.clientDispatcher.register(arg_0));
            command.getCommandBuilders(context).stream().map(LiteralArgumentBuilder::build).forEach(node -> this.addNode(event.getRoot(), (CommandNode<? extends class_2172>)node));
        }
        this.wynntilsCommand.registerWithCommands(arg_0 -> this.clientDispatcher.register(arg_0), context, this.commandInstanceSet);
        this.wynntilsCommand.registerWithCommands(builder -> this.addNode(event.getRoot(), (CommandNode<? extends class_2172>)builder.build()), context, this.commandInstanceSet);
    }

    public void addNode(RootCommandNode<class_2172> root, CommandNode<? extends class_2172> node) {
        root.addChild(node);
    }

    public void addNodeToClientDispatcher(LiteralArgumentBuilder<class_2168> nodeBuilder) {
        this.clientDispatcher.register(nodeBuilder);
    }

    public boolean handleCommand(String message) {
        StringReader reader = new StringReader(message);
        return this.executeCommand(reader, message);
    }

    private boolean executeCommand(StringReader reader, String command) {
        ClientCommandSourceStack source = this.getSource();
        if (source == null) {
            return false;
        }
        ParseResults parse = this.clientDispatcher.parse(reader, (Object)source);
        if (!parse.getExceptions().isEmpty() || parse.getContext().getCommand() == null && parse.getContext().getChild() == null) {
            return false;
        }
        try {
            this.clientDispatcher.execute(parse);
        }
        catch (CommandSyntaxException e) {
            McUtils.sendErrorToClient(e.getRawMessage().getString());
            if (e.getInput() != null && e.getCursor() >= 0) {
                int cursor = Math.min(e.getCursor(), e.getInput().length());
                class_5250 text = class_2561.method_43470((String)"").method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11745, command)));
                if (cursor > 10) {
                    text.method_27693("...");
                }
                text.method_27693(e.getInput().substring(Math.max(0, cursor - 10), cursor));
                if (cursor < e.getInput().length()) {
                    text.method_10852((class_2561)class_2561.method_43470((String)e.getInput().substring(cursor)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1073}));
                }
                text.method_10852((class_2561)class_2561.method_43471((String)"command.context.here").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
                this.sendError(text);
            }
        }
        catch (RuntimeException e) {
            class_5250 error = class_2561.method_43470((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
            this.sendError(class_2561.method_43471((String)"command.failed").method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)error))));
            WynntilsMod.error("Failed to execute command.", e);
        }
        return true;
    }

    private ClientCommandSourceStack getSource() {
        class_746 player = McUtils.player();
        if (player == null) {
            return null;
        }
        return new ClientCommandSourceStack(player);
    }

    private void sendError(class_5250 error) {
        McUtils.sendMessageToClient((class_2561)error.method_27692(class_124.field_1061));
    }

    public List<Command> getCommandInstanceSet() {
        return this.commandInstanceSet;
    }

    private void registerCommand(Command command) {
        this.commandInstanceSet.add(command);
    }

    private void registerCommandWithCommandSet(WynntilsCommand command) {
        this.wynntilsCommand = command;
    }

    private void registerAllCommands() {
        this.registerCommand(new BombBellCommand());
        this.registerCommand(new CompassCommand());
        this.registerCommand(new ConfigCommand());
        this.registerCommand(new FeatureCommand());
        this.registerCommand(new FunctionCommand());
        this.registerCommand(new LocateCommand());
        this.registerCommand(new LootrunCommand());
        this.registerCommand(new MapCommand());
        this.registerCommand(new OnlineMembersCommand());
        this.registerCommand(new PlayerCommand());
        this.registerCommand(new ServersCommand());
        this.registerCommand(new StatisticsCommand());
        this.registerCommand(new TerritoryCommand());
        this.registerCommandWithCommandSet(new WynntilsCommand());
    }
}

