/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.SectionCoordinates;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_241;

public class OverlayPosition {
    private static final Pattern POSITION_PATTERN = Pattern.compile("OverlayPosition\\{verticalOffset=(.+),horizontalOffset=(.+),verticalAlignment=(.+),horizontalAlignment=(.+),anchorSection=(.+)}");
    private final float verticalOffset;
    private final float horizontalOffset;
    private final VerticalAlignment verticalAlignment;
    private final HorizontalAlignment horizontalAlignment;
    private final AnchorSection anchorSection;

    public OverlayPosition(float verticalOffset, float horizontalOffset, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment, AnchorSection anchorSection) {
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.anchorSection = anchorSection;
        this.verticalOffset = verticalOffset;
        this.horizontalOffset = horizontalOffset;
    }

    public OverlayPosition(String string) {
        Matcher matcher = POSITION_PATTERN.matcher(string.replace(" ", ""));
        if (!matcher.matches()) {
            throw new RuntimeException("Failed to parse OverlayPosition");
        }
        try {
            this.verticalOffset = Float.parseFloat(matcher.group(1));
            this.horizontalOffset = Float.parseFloat(matcher.group(2));
            this.verticalAlignment = VerticalAlignment.valueOf(matcher.group(3));
            this.horizontalAlignment = HorizontalAlignment.valueOf(matcher.group(4));
            this.anchorSection = AnchorSection.valueOf(matcher.group(5));
        }
        catch (IllegalArgumentException exception) {
            throw new RuntimeException("Failed to parse OverlayPosition", exception);
        }
    }

    public AnchorSection getAnchorSection() {
        return this.anchorSection;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public float getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public float getVerticalOffset() {
        return this.verticalOffset;
    }

    public String toString() {
        return "OverlayPosition{verticalOffset=" + this.verticalOffset + ", horizontalOffset=" + this.horizontalOffset + ", verticalAlignment=" + String.valueOf(this.verticalAlignment) + ", horizontalAlignment=" + String.valueOf(this.horizontalAlignment) + ", anchorSection=" + String.valueOf((Object)this.anchorSection) + "}";
    }

    public static OverlayPosition getBestPositionFor(Overlay overlay, float oldRenderX, float oldRenderY, float offsetX, float offsetY) {
        class_241 referencePoint = new class_241(overlay.getRenderX() + overlay.getWidth() / 2.0f, overlay.getRenderY() + overlay.getHeight() / 2.0f);
        AnchorSection section = Arrays.stream(AnchorSection.values()).filter(anchorSection -> Managers.Overlay.getSection((AnchorSection)((Object)anchorSection)).overlaps(referencePoint.field_1343, referencePoint.field_1342)).findAny().orElse(AnchorSection.MIDDLE);
        SectionCoordinates sectionCoordinates = Managers.Overlay.getSection(section);
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.RIGHT;
        float horizontalChunkWidth = (float)(sectionCoordinates.x2() - sectionCoordinates.x1()) / 3.0f;
        if (referencePoint.field_1343 < (float)sectionCoordinates.x1() + horizontalChunkWidth) {
            horizontalAlignment = HorizontalAlignment.LEFT;
        } else if (referencePoint.field_1343 < (float)sectionCoordinates.x1() + horizontalChunkWidth * 2.0f) {
            horizontalAlignment = HorizontalAlignment.CENTER;
        }
        VerticalAlignment verticalAlignment = VerticalAlignment.BOTTOM;
        float verticalChunkHeight = (float)(sectionCoordinates.y2() - sectionCoordinates.y1()) / 3.0f;
        if (referencePoint.field_1342 < (float)sectionCoordinates.y1() + verticalChunkHeight) {
            verticalAlignment = VerticalAlignment.TOP;
        } else if (referencePoint.field_1342 < (float)sectionCoordinates.y1() + verticalChunkHeight * 2.0f) {
            verticalAlignment = VerticalAlignment.MIDDLE;
        }
        OverlayPosition newOverlayPositionTemp = new OverlayPosition(0.0f, 0.0f, verticalAlignment, horizontalAlignment, section);
        float renderX = overlay.getRenderX(newOverlayPositionTemp);
        float renderY = overlay.getRenderY(newOverlayPositionTemp);
        return new OverlayPosition(oldRenderY - renderY + offsetY, oldRenderX - renderX + offsetX, verticalAlignment, horizontalAlignment, section);
    }

    public static enum AnchorSection {
        TOP_LEFT(0),
        TOP_MIDDLE(1),
        TOP_RIGHT(2),
        MIDDLE_LEFT(3),
        MIDDLE(4),
        MIDDLE_RIGHT(5),
        BOTTOM_LEFT(6),
        BOTTOM_MIDDLE(7),
        BOTTOM_RIGHT(8);

        private final int index;

        private AnchorSection(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

