/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.crowdsource;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.crowdsource.type.CrowdSourcedDataGameVersion;
import com.wynntils.core.crowdsource.type.CrowdSourcedDataType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;

public class CrowdSourcedData {
    private final Map<CrowdSourcedDataGameVersion, Map<CrowdSourcedDataType, Set<Object>>> data = new ConcurrentSkipListMap<CrowdSourcedDataGameVersion, Map<CrowdSourcedDataType, Set<Object>>>();

    CrowdSourcedData() {
    }

    CrowdSourcedData(Map<CrowdSourcedDataGameVersion, Map<CrowdSourcedDataType, Set<Object>>> deserializedData) {
        this.data.putAll(deserializedData);
    }

    <T> void putData(CrowdSourcedDataGameVersion version, CrowdSourcedDataType crowdSourcedDataType, T crowdSourceData) {
        if (crowdSourcedDataType.getDataClass() != crowdSourceData.getClass()) {
            throw new IllegalArgumentException("The provided data does not match the crows sourced data type.");
        }
        this.data.computeIfAbsent(version, k -> new TreeMap()).computeIfAbsent(crowdSourcedDataType, k -> new ConcurrentSkipListSet()).add(crowdSourceData);
    }

    <T> Set<T> getData(CrowdSourcedDataGameVersion version, CrowdSourcedDataType crowdSourcedDataType, T dataClass) {
        if (crowdSourcedDataType.getDataClass() != dataClass) {
            throw new IllegalArgumentException("The provided data class does not match the crowd sourced data type.");
        }
        return this.data.getOrDefault((Object)version, Map.of()).getOrDefault((Object)crowdSourcedDataType, Set.of()).stream().map(crowdSourcedDataType.getDataClass()::cast).collect(Collectors.toSet());
    }

    public static class CrowdSourceDataSerializer
    implements JsonDeserializer<CrowdSourcedData> {
        public CrowdSourcedData deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (!jsonObject.has("data")) {
                return new CrowdSourcedData();
            }
            JsonObject dataObject = jsonObject.getAsJsonObject("data");
            ConcurrentSkipListMap<CrowdSourcedDataGameVersion, Map<CrowdSourcedDataType, Set<Object>>> deserializedData = new ConcurrentSkipListMap<CrowdSourcedDataGameVersion, Map<CrowdSourcedDataType, Set<Object>>>();
            for (Map.Entry gameVersionEntry : dataObject.entrySet()) {
                CrowdSourcedDataGameVersion gameVersion = (CrowdSourcedDataGameVersion)((Object)context.deserialize((JsonElement)new JsonPrimitive((String)gameVersionEntry.getKey()), CrowdSourcedDataGameVersion.class));
                JsonObject gameVersionObject = ((JsonElement)gameVersionEntry.getValue()).getAsJsonObject();
                ConcurrentSkipListMap deserializedGameVersionData = new ConcurrentSkipListMap();
                for (Map.Entry crowdSourceDataTypeEntry : gameVersionObject.entrySet()) {
                    try {
                        CrowdSourcedDataType crowdSourcedDataType = (CrowdSourcedDataType)((Object)context.deserialize((JsonElement)new JsonPrimitive((String)crowdSourceDataTypeEntry.getKey()), CrowdSourcedDataType.class));
                        JsonArray crowdSourcedTypeArray = ((JsonElement)crowdSourceDataTypeEntry.getValue()).getAsJsonArray();
                        ConcurrentSkipListSet deserializedCrowdSourcedTypeData = new ConcurrentSkipListSet();
                        crowdSourcedTypeArray.forEach(entry -> deserializedCrowdSourcedTypeData.add(context.deserialize(entry, crowdSourcedDataType.getDataClass())));
                        deserializedGameVersionData.put(crowdSourcedDataType, deserializedCrowdSourcedTypeData);
                    }
                    catch (Exception exception) {
                        WynntilsMod.warn("Could not deserialize crowd sourced data type: " + (String)crowdSourceDataTypeEntry.getKey() + " for game version: " + (String)gameVersionEntry.getKey());
                    }
                }
                deserializedData.put(gameVersion, deserializedGameVersionData);
            }
            return new CrowdSourcedData(deserializedData);
        }
    }
}

