/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.crowdsource;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.crowdsource.CrowdSourcedData;
import com.wynntils.core.crowdsource.CrowdSourcedDataCollector;
import com.wynntils.core.crowdsource.type.CrowdSourcedDataGameVersion;
import com.wynntils.core.crowdsource.type.CrowdSourcedDataType;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.crowdsource.FastTravelLocationDataCollector;
import com.wynntils.crowdsource.LootrunLocationDataCollector;
import com.wynntils.crowdsource.NpcLocationDataCollector;
import com.wynntils.crowdsource.ProfessionNodeLocationDataCollector;
import com.wynntils.crowdsource.ProfessionStationLocationDataCollector;
import com.wynntils.features.wynntils.DataCrowdSourcingFeature;
import com.wynntils.utils.type.ConfirmedBoolean;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CrowdSourcedDataManager
extends Manager {
    public static final CrowdSourcedDataGameVersion CURRENT_GAME_VERSION = CrowdSourcedDataGameVersion.VERSION_211_PATCH_6;
    @Persisted
    private final Storage<CrowdSourcedData> collectedData = new Storage<CrowdSourcedData>(new CrowdSourcedData());
    private final Map<CrowdSourcedDataType, CrowdSourcedDataCollector<?>> collectors = new HashMap();

    public CrowdSourcedDataManager() {
        super(List.of());
        this.registerCollectors();
    }

    public <T> void putData(CrowdSourcedDataType crowdSourcedDataType, T crowdSourcedData) {
        if (this.getDataCollectionState(crowdSourcedDataType) != ConfirmedBoolean.TRUE) {
            return;
        }
        ((CrowdSourcedData)this.collectedData.get()).putData(CURRENT_GAME_VERSION, crowdSourcedDataType, crowdSourcedData);
        this.collectedData.touched();
    }

    public <T> Set<T> getData(CrowdSourcedDataType crowdSourcedDataType) {
        return ((CrowdSourcedData)this.collectedData.get()).getData(CURRENT_GAME_VERSION, crowdSourcedDataType, crowdSourcedDataType.getDataClass());
    }

    public ConfirmedBoolean getDataCollectionState(CrowdSourcedDataType crowdSourcedDataType) {
        if (!this.isDataCollectionEnabled()) {
            return ConfirmedBoolean.FALSE;
        }
        ConfirmedBoolean collectionEnabledForType = ((Map)Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).crowdSourcedDataTypeEnabledMap.get()).getOrDefault((Object)crowdSourcedDataType, ConfirmedBoolean.UNCONFIRMED);
        return collectionEnabledForType;
    }

    public boolean isDataCollectionEnabled() {
        return Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).isEnabled();
    }

    private void registerCollectors() {
        this.registerCollector(CrowdSourcedDataType.LOOTRUN_TASK_LOCATIONS, new LootrunLocationDataCollector());
        this.registerCollector(CrowdSourcedDataType.NPC_LOCATIONS, new NpcLocationDataCollector());
        this.registerCollector(CrowdSourcedDataType.PROFESSION_NODE_LOCATIONS, new ProfessionNodeLocationDataCollector());
        this.registerCollector(CrowdSourcedDataType.PROFESSION_CRAFTING_STATION_LOCATIONS, new ProfessionStationLocationDataCollector());
        this.registerCollector(CrowdSourcedDataType.FAST_TRAVEL_LOCATIONS, new FastTravelLocationDataCollector());
    }

    private void registerCollector(CrowdSourcedDataType crowdSourcedDataType, CrowdSourcedDataCollector<?> collector) {
        Class collectorTypeClass = (Class)((ParameterizedType)collector.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (!collectorTypeClass.equals(crowdSourcedDataType.getDataClass())) {
            throw new IllegalStateException("The provided collector does not collect the provided crowd sourced data type.");
        }
        WynntilsMod.registerEventListener(collector);
        this.collectors.put(crowdSourcedDataType, collector);
    }
}

