/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.event.TextDisplayChangedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.models.guild.label.GuildSeasonLeaderboardLabelInfo;
import com.wynntils.models.guild.profile.GuildProfile;
import com.wynntils.models.guild.type.GuildLeaderboardInfo;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.ColorChatFormatting;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

public class ExtendedSeasonLeaderboardFeature
extends Feature {
    private final Map<Integer, Map<Integer, Long>> seasonRatings = new HashMap<Integer, Map<Integer, Long>>();
    @Persisted
    private final Config<Boolean> useShortSeasonRankingStrings = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> highlightOwnGuild = new Config<Boolean>(true);
    @Persisted
    private final Config<ColorChatFormatting> guildHighlightColor = new Config<ColorChatFormatting>(ColorChatFormatting.GREEN);

    @SubscribeEvent
    public void onLabelIdentified(LabelIdentifiedEvent event) {
        LabelInfo labelInfo = event.getLabelInfo();
        if (labelInfo instanceof GuildSeasonLeaderboardLabelInfo) {
            GuildSeasonLeaderboardLabelInfo guildSeasonLeaderboardLabelInfo = (GuildSeasonLeaderboardLabelInfo)labelInfo;
            Map seasonMap = this.seasonRatings.getOrDefault(guildSeasonLeaderboardLabelInfo.getSeason(), new HashMap());
            guildSeasonLeaderboardLabelInfo.getGuildLeaderboardInfo().forEach(guildLeaderboardInfo -> seasonMap.put(guildLeaderboardInfo.position(), guildLeaderboardInfo.rating()));
            this.seasonRatings.put(guildSeasonLeaderboardLabelInfo.getSeason(), seasonMap);
        }
    }

    @SubscribeEvent
    public void onLabelChanged(TextDisplayChangedEvent.Text event) {
        if (event.getLabelInfo().isEmpty()) {
            return;
        }
        LabelInfo labelInfo = event.getLabelInfo().get();
        if (labelInfo instanceof GuildSeasonLeaderboardLabelInfo) {
            GuildSeasonLeaderboardLabelInfo guildSeasonLeaderboardLabelInfo = (GuildSeasonLeaderboardLabelInfo)labelInfo;
            event.setText(this.getUpdatedLeaderboard(guildSeasonLeaderboardLabelInfo));
        }
    }

    private StyledText getUpdatedLeaderboard(GuildSeasonLeaderboardLabelInfo guildSeasonLeaderboardLabelInfo) {
        class_5250 newLabel = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("Season " + guildSeasonLeaderboardLabelInfo.getSeason() + " Leaderboard")).method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}));
        if (guildSeasonLeaderboardLabelInfo.isCurrentSeason()) {
            int seasonEnd = guildSeasonLeaderboardLabelInfo.getEndingDate().getFirst();
            newLabel.method_10852((class_2561)class_2561.method_43470((String)"\nSeason ends in ").method_27692(class_124.field_1080));
            newLabel.method_10852((class_2561)class_2561.method_43470((String)(seasonEnd + " " + guildSeasonLeaderboardLabelInfo.getTimeUnit() + " \n\n")).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        } else {
            int endMonth = guildSeasonLeaderboardLabelInfo.getEndingDate().getFirst();
            int endDay = guildSeasonLeaderboardLabelInfo.getEndingDate().get(1);
            int endYear = guildSeasonLeaderboardLabelInfo.getEndingDate().get(2);
            String formattedDate = String.format("%02d/%02d/%d", endMonth, endDay, endYear);
            newLabel.method_10852((class_2561)class_2561.method_43470((String)"\nSeason ended at ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)(formattedDate + "\n\n")).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}));
        }
        Map seasonMap = this.seasonRatings.getOrDefault(guildSeasonLeaderboardLabelInfo.getSeason(), new HashMap());
        for (GuildLeaderboardInfo leaderboardPos : guildSeasonLeaderboardLabelInfo.getGuildLeaderboardInfo()) {
            class_124 placeColor = class_124.field_1080;
            if (leaderboardPos.position() <= 3) {
                placeColor = class_124.field_1065;
            } else if (leaderboardPos.position() <= 6) {
                placeColor = class_124.field_1054;
            } else if (leaderboardPos.position() <= 9) {
                placeColor = class_124.field_1068;
            }
            class_5250 placement = class_2561.method_43470((String)String.valueOf(leaderboardPos.position())).method_27692(placeColor);
            if (leaderboardPos.position() == 1) {
                placement.method_27692(class_124.field_1067);
            }
            newLabel.method_10852((class_2561)placement).method_10852((class_2561)class_2561.method_43470((String)" - ")).method_27692(class_124.field_1080);
            Optional<GuildProfile> guildProfile = Models.Guild.getGuildProfile(leaderboardPos.guildName());
            String prefix = "[" + guildProfile.map(GuildProfile::prefix).orElse("???") + "]";
            class_124 guildColor = class_124.field_1075;
            if (((Boolean)this.highlightOwnGuild.get()).booleanValue() && leaderboardPos.guildName().equals(Models.Guild.getGuildName())) {
                guildColor = ((ColorChatFormatting)((Object)this.guildHighlightColor.get())).getChatFormatting();
            }
            Object scoreString = (Boolean)this.useShortSeasonRankingStrings.get() != false ? "(" + StringUtils.integerToShortString(leaderboardPos.rating()) + ") SR" : String.format("(%,d SR)", leaderboardPos.rating());
            long lowerGuildRating = seasonMap.getOrDefault(leaderboardPos.position() + 1, -1L);
            Object ratingDifference = " (+???)";
            if (lowerGuildRating != -1L) {
                long difference = leaderboardPos.rating() - lowerGuildRating;
                ratingDifference = ((Boolean)this.useShortSeasonRankingStrings.get()).booleanValue() ? " (+" + StringUtils.integerToShortString(difference) + ")" : String.format(" (+%,d)", difference);
            } else if (guildSeasonLeaderboardLabelInfo.isLastPage()) {
                ratingDifference = "";
            }
            newLabel.method_10852((class_2561)class_2561.method_43470((String)(leaderboardPos.guildName() + " " + prefix)).method_27692(guildColor)).method_10852((class_2561)class_2561.method_43470((String)(" " + (String)scoreString)).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)ratingDifference).method_27692(class_124.field_1060)).method_27693("\n");
        }
        class_124 previousPageColor = guildSeasonLeaderboardLabelInfo.isFirstPage() ? class_124.field_1080 : class_124.field_1060;
        class_124 nextPageColor = guildSeasonLeaderboardLabelInfo.isLastPage() ? class_124.field_1080 : class_124.field_1060;
        newLabel.method_10852((class_2561)class_2561.method_43470((String)"\n\u00ab").method_27695(new class_124[]{previousPageColor, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" \u2b1f ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"\u00bb").method_27695(new class_124[]{nextPageColor, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nClick for Options").method_27692(class_124.field_1054));
        return StyledText.fromComponent((class_2561)newLabel);
    }
}

