/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.containers.event.ValuableFoundEvent;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.models.items.items.game.CorruptedCacheItem;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.InsulatorItem;
import com.wynntils.models.items.items.game.SimulatorItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.neoforged.bus.api.SubscribeEvent;

public class ValuableFoundFeature
extends Feature {
    private static final class_2960 MYTHIC_FOUND_CLASSIC_ID = class_2960.method_60655((String)"wynntils", (String)"misc.mythic-found-classic");
    private static final class_2960 MYTHIC_FOUND_MODERN_ID = class_2960.method_60655((String)"wynntils", (String)"misc.mythic-found-modern");
    private static final class_2960 CACHE_FOUND_ID = class_2960.method_60655((String)"wynntils", (String)"misc.cache-found");
    @Persisted
    private final Config<ValuableFoundSound> chestSound = new Config<ValuableFoundSound>(ValuableFoundSound.MODERN);
    @Persisted
    private final Config<ValuableFoundSound> lootrunSound = new Config<ValuableFoundSound>(ValuableFoundSound.MODERN);
    @Persisted
    private final Config<ValuableFoundSound> aspectFoundSound = new Config<ValuableFoundSound>(ValuableFoundSound.MODERN);
    @Persisted
    private final Config<ValuableFoundSound> tomeFoundSound = new Config<ValuableFoundSound>(ValuableFoundSound.NONE);
    @Persisted
    private final Config<ValuableFoundSound> cacheFoundSound = new Config<ValuableFoundSound>(ValuableFoundSound.CACHE);
    @Persisted
    private final Config<ValuableFoundSound> emeraldPouchSound = new Config<ValuableFoundSound>(ValuableFoundSound.NONE);
    @Persisted
    private final Config<Boolean> showDryStreakMessage = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showAspectDryStreakMessage = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showTomeDryStreakMessage = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> showCacheDryStreakMessage = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showEmeraldPouchDryStreakMessage = new Config<Boolean>(true);
    @Persisted
    private final Config<EmeraldPouchTier> emeraldPouchTier = new Config<EmeraldPouchTier>(EmeraldPouchTier.EIGHT);
    @Persisted
    private final Config<Float> soundVolume = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<Float> soundPitch = new Config<Float>(Float.valueOf(1.0f));

    @SubscribeEvent
    public void onValuableFound(ValuableFoundEvent event) {
        Optional<CorruptedCacheItem> cacheItem;
        class_1799 itemStack = event.getItem();
        if (event.getItemSource() == ValuableFoundEvent.ItemSource.LOOT_CHEST) {
            Optional<GearBoxItem> gearBoxItem;
            if ((((Boolean)this.showDryStreakMessage.get()).booleanValue() || this.chestSound.get() != ValuableFoundSound.NONE) && (gearBoxItem = Models.Item.asWynnItem(itemStack, GearBoxItem.class)).isPresent()) {
                if (gearBoxItem.get().getGearType() != GearType.MASTERY_TOME) {
                    if (this.chestSound.get() != ValuableFoundSound.NONE) {
                        McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.chestSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                    }
                    if (!((Boolean)this.showDryStreakMessage.get()).booleanValue()) {
                        return;
                    }
                    ValuableFoundFeature.sendNormalDryStreakMessage(StyledText.fromComponent(event.getItem().method_7964()));
                }
                return;
            }
            if (this.emeraldPouchTier.get() != EmeraldPouchTier.NONE && (((Boolean)this.showEmeraldPouchDryStreakMessage.get()).booleanValue() || this.emeraldPouchSound.get() != ValuableFoundSound.NONE)) {
                Optional<EmeraldPouchItem> emeraldPouchItem = Models.Item.asWynnItem(itemStack, EmeraldPouchItem.class);
                if (emeraldPouchItem.isPresent() && emeraldPouchItem.get().getTier() >= ((EmeraldPouchTier)((Object)this.emeraldPouchTier.get())).getTier()) {
                    if (this.emeraldPouchSound.get() != ValuableFoundSound.NONE) {
                        McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.emeraldPouchSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                    }
                    if (!((Boolean)this.showEmeraldPouchDryStreakMessage.get()).booleanValue()) {
                        return;
                    }
                    ValuableFoundFeature.sendEmeraldPouchDryStreakMessage(StyledText.fromComponent(event.getItem().method_7964()), ((EmeraldPouchTier)((Object)this.emeraldPouchTier.get())).getTier());
                }
                return;
            }
        }
        if (event.getItemSource() == ValuableFoundEvent.ItemSource.LOOTRUN_REWARD_CHEST && (((Boolean)this.showDryStreakMessage.get()).booleanValue() || this.lootrunSound.get() != ValuableFoundSound.NONE)) {
            Optional<SimulatorItem> simulatorItem;
            Optional<InsulatorItem> insulatorItem;
            boolean validLootrunMythic = false;
            Optional<GearItem> gearItem = Models.Item.asWynnItem(itemStack, GearItem.class);
            if (gearItem.isPresent()) {
                validLootrunMythic = true;
            }
            if ((insulatorItem = Models.Item.asWynnItem(itemStack, InsulatorItem.class)).isPresent()) {
                validLootrunMythic = true;
            }
            if ((simulatorItem = Models.Item.asWynnItem(itemStack, SimulatorItem.class)).isPresent()) {
                validLootrunMythic = true;
            }
            if (validLootrunMythic) {
                if (this.lootrunSound.get() != ValuableFoundSound.NONE) {
                    McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.lootrunSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                }
                if (!((Boolean)this.showDryStreakMessage.get()).booleanValue()) {
                    return;
                }
                this.sendLootrunDryStreakMessage(StyledText.fromComponent(event.getItem().method_7964()));
            }
        }
        if (event.getItemSource() == ValuableFoundEvent.ItemSource.RAID_REWARD_CHEST) {
            Optional<TomeItem> tomeItem;
            Optional<AspectItem> aspectItem;
            if ((((Boolean)this.showAspectDryStreakMessage.get()).booleanValue() || this.aspectFoundSound.get() != ValuableFoundSound.NONE) && (aspectItem = Models.Item.asWynnItem(itemStack, AspectItem.class)).isPresent()) {
                if (this.aspectFoundSound.get() != ValuableFoundSound.NONE) {
                    McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.aspectFoundSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                }
                if (((Boolean)this.showAspectDryStreakMessage.get()).booleanValue()) {
                    ValuableFoundFeature.sendAspectDryStreakMessage(StyledText.fromComponent(event.getItem().method_7964()));
                }
                return;
            }
            if ((((Boolean)this.showTomeDryStreakMessage.get()).booleanValue() || this.tomeFoundSound.get() != ValuableFoundSound.NONE) && (tomeItem = Models.Item.asWynnItem(itemStack, TomeItem.class)).isPresent()) {
                if (this.tomeFoundSound.get() != ValuableFoundSound.NONE) {
                    McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.tomeFoundSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
                }
                if (((Boolean)this.showTomeDryStreakMessage.get()).booleanValue()) {
                    ValuableFoundFeature.sendTomeDryStreakMessage(StyledText.fromComponent(event.getItem().method_7964()));
                }
                return;
            }
        }
        if (event.getItemSource() == ValuableFoundEvent.ItemSource.WORLD_EVENT && (((Boolean)this.showCacheDryStreakMessage.get()).booleanValue() || this.cacheFoundSound.get() != ValuableFoundSound.NONE) && (cacheItem = Models.Item.asWynnItem(itemStack, CorruptedCacheItem.class)).isPresent()) {
            if (this.cacheFoundSound.get() != ValuableFoundSound.NONE) {
                McUtils.playSoundAmbient(((ValuableFoundSound)((Object)this.cacheFoundSound.get())).getSoundEvent(), ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
            }
            if (((Boolean)this.showCacheDryStreakMessage.get()).booleanValue()) {
                ValuableFoundFeature.sendCacheDryStreakMessage(StyledText.fromComponent(event.getItem().method_7964()));
            }
            return;
        }
    }

    private void sendLootrunDryStreakMessage(StyledText itemName) {
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"Dry streak broken! Found an ").method_27692(class_124.field_1076).method_10852((class_2561)itemName.getComponent()).method_10852((class_2561)class_2561.method_43470((String)" after ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(Models.Lootrun.dryPulls.get()) + " pulls")).method_27692(class_124.field_1065))).method_10852((class_2561)class_2561.method_43470((String)" without a mythic.").method_27692(class_124.field_1076)));
    }

    private static void sendNormalDryStreakMessage(StyledText itemName) {
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"Dry streak broken! Found an ").method_27692(class_124.field_1076).method_10852((class_2561)itemName.getComponent()).method_10852((class_2561)class_2561.method_43470((String)" in chest ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)("#" + Models.LootChest.getOpenedChestCount())).method_27692(class_124.field_1065))).method_10852((class_2561)class_2561.method_43470((String)" after ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Models.LootChest.getDryCount())).method_27692(class_124.field_1064))).method_10852((class_2561)class_2561.method_43470((String)" dry chests and ")).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Models.LootChest.getDryBoxes())).method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" dry boxes.")));
    }

    private static void sendCacheDryStreakMessage(StyledText itemName) {
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"Dry streak broken! Found a ").method_54663(CustomColor.fromHexString("#800080").asInt()).method_10852((class_2561)itemName.getComponent()).method_10852((class_2561)class_2561.method_43470((String)" after ").method_54663(CustomColor.fromHexString("#800080").asInt()).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Models.WorldEvent.dryAnnihilations.get())).method_54663(CustomColor.fromHexString("#FFD700").asInt()))).method_10852((class_2561)class_2561.method_43470((String)" dry Annihilations.").method_54663(CustomColor.fromHexString("#800080").asInt())));
    }

    private static void sendEmeraldPouchDryStreakMessage(StyledText itemName, int tier) {
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"Dry streak broken! Found an ").method_54663(CustomColor.fromHexString("#7CFC00").asInt()).method_10852((class_2561)itemName.getComponent()).method_10852((class_2561)class_2561.method_43470((String)" in chest ").method_54663(CustomColor.fromHexString("#7CFC00").asInt()).method_10852((class_2561)class_2561.method_43470((String)("#" + Models.LootChest.getOpenedChestCount())).method_27692(class_124.field_1062))).method_10852((class_2561)class_2561.method_43470((String)" after ").method_54663(CustomColor.fromHexString("#7CFC00").asInt()).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(Models.LootChest.getDryPouchCount(tier))).method_54663(CustomColor.fromHexString("#228B22").asInt()))).method_10852((class_2561)class_2561.method_43470((String)" dry chests.")));
    }

    private static void sendAspectDryStreakMessage(StyledText itemName) {
        ValuableFoundFeature.sendRaidDryStreakMessage(itemName, Models.Raid.getRaidsWithoutMythicAspect(), Models.Raid.getAspectPullsWithoutMythicAspect(), "aspect");
    }

    private static void sendTomeDryStreakMessage(StyledText itemName) {
        ValuableFoundFeature.sendRaidDryStreakMessage(itemName, Models.Raid.getRaidsWithoutMythicTome(), Models.Raid.getRewardPullsWithoutMythicTome(), "reward");
    }

    private static void sendRaidDryStreakMessage(StyledText itemName, int numRaids, int numPulls, String pullType) {
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"Dry streak broken! Found ").method_27692(class_124.field_1076).method_10852((class_2561)itemName.getComponent()).method_10852((class_2561)class_2561.method_43470((String)" after ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)(numRaids + " raids")).method_27692(class_124.field_1065))).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(numPulls + " " + pullType + " pulls")).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" without a mythic.")).method_27692(class_124.field_1076));
    }

    private static enum ValuableFoundSound {
        MODERN(class_3414.method_47908((class_2960)MYTHIC_FOUND_MODERN_ID)),
        CLASSIC(class_3414.method_47908((class_2960)MYTHIC_FOUND_CLASSIC_ID)),
        CACHE(class_3414.method_47908((class_2960)CACHE_FOUND_ID)),
        NONE(null);

        private final class_3414 soundEvent;

        private ValuableFoundSound(class_3414 soundEvent) {
            this.soundEvent = soundEvent;
        }

        public class_3414 getSoundEvent() {
            return this.soundEvent;
        }
    }

    private static enum EmeraldPouchTier {
        NONE(-1),
        SEVEN(7),
        EIGHT(8),
        NINE(9),
        TEN(10);

        private final int tier;

        private EmeraldPouchTier(int tier) {
            this.tier = tier;
        }

        public int getTier() {
            return this.tier;
        }
    }
}

