/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.CommandsAddedEvent;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMMANDS)
public class AddCommandExpansionFeature
extends Feature {
    private static final SuggestionProvider<class_2168> PLAYER_NAME_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Models.Player.getAllPlayerNames(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> FRIEND_NAME_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(Models.Friends.getFriends(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> PARTY_NAME_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Models.Party.getPartyMembers().stream().filter(p -> !p.equals(McUtils.playerName())), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> SERVERS_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(Models.ServerList.getServers(), (SuggestionsBuilder)builder);
    @Persisted
    private final Config<Boolean> includeDeprecatedCommands = new Config<Boolean>(false);
    @Persisted
    private final Config<AliasCommandLevel> includeAliases = new Config<AliasCommandLevel>(AliasCommandLevel.SHORT_FORMS);

    @SubscribeEvent
    public void onCommandPacket(CommandsAddedEvent event) {
        RootCommandNode<class_2172> root = event.getRoot();
        this.addArgumentlessCommandNodes(root);
        this.addChangetagCommandNode(root);
        this.addEmoteCommandNode(root);
        this.addFriendCommandNode(root);
        this.addGuildCommandNode(root);
        this.addIgnoreCommandNode(root);
        this.addHousingCommandNode(root);
        this.addMessagingCommandNodes(root);
        this.addMiscCommandNodes(root);
        this.addParticlesCommandNode(root);
        this.addPartyCommandNode(root);
        this.addPlayerCommandNodes(root);
        this.addToggleCommandNode(root);
        if (((Boolean)this.includeDeprecatedCommands.get()).booleanValue()) {
            this.addDeprecatedCommandNodes(root);
        }
    }

    private void addNode(RootCommandNode<class_2172> root, CommandNode<? extends class_2172> node) {
        Managers.Command.addNode(root, node);
    }

    private void addAlias(RootCommandNode<class_2172> root, CommandNode<class_2168> originalNode, String aliasName, AliasCommandLevel level) {
        if (((AliasCommandLevel)((Object)this.includeAliases.get())).ordinal() >= level.ordinal()) {
            this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)aliasName).redirect(originalNode)).build());
        }
    }

    private void addArgumentlessCommandNodes(RootCommandNode<class_2172> root) {
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"claimingredientbomb").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"claimitembomb").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"daily").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"fixquests").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"fixstart").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"forum").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"help").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"link").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"rules").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"sign").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"skiptutorial").build());
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"tracking").build());
        LiteralCommandNode hubNode = class_2170.method_9247((String)"hub").build();
        this.addNode(root, (CommandNode<? extends class_2172>)hubNode);
        this.addAlias(root, (CommandNode<class_2168>)hubNode, "change", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)hubNode, "lobby", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)hubNode, "leave", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)hubNode, "port", AliasCommandLevel.ALL);
        LiteralCommandNode classNode = class_2170.method_9247((String)"class").build();
        this.addNode(root, (CommandNode<? extends class_2172>)classNode);
        this.addAlias(root, (CommandNode<class_2168>)classNode, "classes", AliasCommandLevel.ALL);
        LiteralCommandNode charactersNode = class_2170.method_9247((String)"characters").build();
        this.addNode(root, (CommandNode<? extends class_2172>)charactersNode);
        this.addAlias(root, (CommandNode<class_2168>)charactersNode, "char", AliasCommandLevel.ALL);
        LiteralCommandNode crateNode = class_2170.method_9247((String)"crate").build();
        this.addNode(root, (CommandNode<? extends class_2172>)crateNode);
        this.addAlias(root, (CommandNode<class_2168>)crateNode, "crates", AliasCommandLevel.ALL);
        LiteralCommandNode disguisesNode = class_2170.method_9247((String)"disguises").build();
        this.addNode(root, (CommandNode<? extends class_2172>)disguisesNode);
        this.addAlias(root, (CommandNode<class_2168>)disguisesNode, "disguise", AliasCommandLevel.ALL);
        LiteralCommandNode effectsNode = class_2170.method_9247((String)"effects").build();
        this.addNode(root, (CommandNode<? extends class_2172>)effectsNode);
        this.addAlias(root, (CommandNode<class_2168>)effectsNode, "effect", AliasCommandLevel.ALL);
        LiteralCommandNode hatsNode = class_2170.method_9247((String)"hats").build();
        this.addNode(root, (CommandNode<? extends class_2172>)hatsNode);
        this.addAlias(root, (CommandNode<class_2168>)hatsNode, "hat", AliasCommandLevel.ALL);
        LiteralCommandNode mountsNode = class_2170.method_9247((String)"mounts").build();
        this.addNode(root, (CommandNode<? extends class_2172>)mountsNode);
        this.addAlias(root, (CommandNode<class_2168>)mountsNode, "mount", AliasCommandLevel.ALL);
        LiteralCommandNode weaponsNode = class_2170.method_9247((String)"weapons").build();
        this.addNode(root, (CommandNode<? extends class_2172>)weaponsNode);
        this.addAlias(root, (CommandNode<class_2168>)weaponsNode, "weapon", AliasCommandLevel.ALL);
        LiteralCommandNode consumablesNode = class_2170.method_9247((String)"consumables").build();
        this.addNode(root, (CommandNode<? extends class_2172>)consumablesNode);
        this.addAlias(root, (CommandNode<class_2168>)consumablesNode, "bomb", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)consumablesNode, "bombs", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)consumablesNode, "token", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)consumablesNode, "tokens", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)consumablesNode, "consumable", AliasCommandLevel.ALL);
        LiteralCommandNode useNode = class_2170.method_9247((String)"use").build();
        this.addNode(root, (CommandNode<? extends class_2172>)useNode);
        this.addAlias(root, (CommandNode<class_2168>)useNode, "rank", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)useNode, "shop", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)useNode, "store", AliasCommandLevel.ALL);
        LiteralCommandNode killNode = class_2170.method_9247((String)"kill").build();
        this.addNode(root, (CommandNode<? extends class_2172>)killNode);
        this.addAlias(root, (CommandNode<class_2168>)killNode, "die", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)killNode, "suicide", AliasCommandLevel.ALL);
        LiteralCommandNode itemlockNode = class_2170.method_9247((String)"itemlock").build();
        this.addNode(root, (CommandNode<? extends class_2172>)itemlockNode);
        this.addAlias(root, (CommandNode<class_2168>)itemlockNode, "ilock", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)itemlockNode, "lock", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)itemlockNode, "locki", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)itemlockNode, "lockitem", AliasCommandLevel.ALL);
        LiteralCommandNode petNode = class_2170.method_9247((String)"pet").build();
        this.addNode(root, (CommandNode<? extends class_2172>)petNode);
        this.addAlias(root, (CommandNode<class_2168>)petNode, "pets", AliasCommandLevel.ALL);
        LiteralCommandNode partyfinderNode = class_2170.method_9247((String)"partyfinder").build();
        this.addNode(root, (CommandNode<? extends class_2172>)partyfinderNode);
        this.addAlias(root, (CommandNode<class_2168>)partyfinderNode, "pfinder", AliasCommandLevel.SHORT_FORMS);
        LiteralCommandNode streamNode = class_2170.method_9247((String)"stream").build();
        this.addNode(root, (CommandNode<? extends class_2172>)streamNode);
        this.addAlias(root, (CommandNode<class_2168>)streamNode, "streamer", AliasCommandLevel.ALL);
        LiteralCommandNode totemNode = class_2170.method_9247((String)"totem").build();
        this.addNode(root, (CommandNode<? extends class_2172>)totemNode);
        this.addAlias(root, (CommandNode<class_2168>)totemNode, "totems", AliasCommandLevel.ALL);
        LiteralCommandNode huntedNode = class_2170.method_9247((String)"hunted").build();
        this.addNode(root, (CommandNode<? extends class_2172>)huntedNode);
        this.addAlias(root, (CommandNode<class_2168>)huntedNode, "pvp", AliasCommandLevel.SHORT_FORMS);
        LiteralCommandNode recruitNode = class_2170.method_9247((String)"recruit").build();
        this.addNode(root, (CommandNode<? extends class_2172>)recruitNode);
        this.addAlias(root, (CommandNode<class_2168>)recruitNode, "rf", AliasCommandLevel.ALL);
    }

    private void addChangetagCommandNode(RootCommandNode<class_2172> root) {
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"changetag").then((ArgumentBuilder)class_2170.method_9247((String)"VIP"))).then((ArgumentBuilder)class_2170.method_9247((String)"VIP+"))).then((ArgumentBuilder)class_2170.method_9247((String)"HERO"))).then((ArgumentBuilder)class_2170.method_9247((String)"HERO+"))).then((ArgumentBuilder)class_2170.method_9247((String)"CHAMPION"))).then((ArgumentBuilder)class_2170.method_9247((String)"RESET"))).build());
    }

    private void addEmoteCommandNode(RootCommandNode<class_2172> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"emote").then((ArgumentBuilder)class_2170.method_9247((String)"cheer"))).then((ArgumentBuilder)class_2170.method_9247((String)"clap"))).then((ArgumentBuilder)class_2170.method_9247((String)"dance"))).then((ArgumentBuilder)class_2170.method_9247((String)"explode"))).then((ArgumentBuilder)class_2170.method_9247((String)"faint"))).then((ArgumentBuilder)class_2170.method_9247((String)"flop"))).then((ArgumentBuilder)class_2170.method_9247((String)"hug"))).then((ArgumentBuilder)class_2170.method_9247((String)"relax"))).then((ArgumentBuilder)class_2170.method_9247((String)"jump"))).then((ArgumentBuilder)class_2170.method_9247((String)"wave"))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)node);
        this.addAlias(root, (CommandNode<class_2168>)node, "emotes", AliasCommandLevel.ALL);
    }

    private void addFriendCommandNode(RootCommandNode<class_2172> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"friend").then((ArgumentBuilder)class_2170.method_9247((String)"list"))).then((ArgumentBuilder)class_2170.method_9247((String)"online"))).then(class_2170.method_9247((String)"add").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"remove").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(FRIEND_NAME_SUGGESTION_PROVIDER)))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)node);
        this.addAlias(root, (CommandNode<class_2168>)node, "f", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<class_2168>)node, "friends", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)node, "buddy", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)node, "buddies", AliasCommandLevel.ALL);
    }

    private void addGuildCommandNode(RootCommandNode<class_2172> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"guild").then((ArgumentBuilder)class_2170.method_9247((String)"attack"))).then((ArgumentBuilder)class_2170.method_9247((String)"contribute"))).then((ArgumentBuilder)class_2170.method_9247((String)"defend"))).then(class_2170.method_9247((String)"invite").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"join").then((ArgumentBuilder)class_2170.method_9244((String)"tag", (ArgumentType)StringArgumentType.greedyString())))).then(class_2170.method_9247((String)"kick").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)class_2170.method_9247((String)"leaderboard"))).then((ArgumentBuilder)class_2170.method_9247((String)"leave"))).then((ArgumentBuilder)class_2170.method_9247((String)"list"))).then((ArgumentBuilder)class_2170.method_9247((String)"log"))).then((ArgumentBuilder)class_2170.method_9247((String)"manage"))).then(class_2170.method_9247((String)"rank").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).then((ArgumentBuilder)class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.string()))))).then((ArgumentBuilder)class_2170.method_9247((String)"rewards"))).then((ArgumentBuilder)class_2170.method_9247((String)"stats"))).then((ArgumentBuilder)class_2170.method_9247((String)"territory"))).then(class_2170.method_9247((String)"xp").then((ArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer())))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)node);
        this.addAlias(root, (CommandNode<class_2168>)node, "gu", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<class_2168>)node, "guilds", AliasCommandLevel.ALL);
    }

    private void addIgnoreCommandNode(RootCommandNode<class_2172> root) {
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ignore").then(class_2170.method_9247((String)"add").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"remove").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).build());
    }

    private void addHousingCommandNode(RootCommandNode<class_2172> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"housing").then(class_2170.method_9247((String)"allowedit").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"ban").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"disallowedit").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)class_2170.method_9247((String)"edit"))).then(class_2170.method_9247((String)"invite").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"kick").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)class_2170.method_9247((String)"kickall"))).then((ArgumentBuilder)class_2170.method_9247((String)"leave"))).then((ArgumentBuilder)class_2170.method_9247((String)"public"))).then(class_2170.method_9247((String)"unban").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)class_2170.method_9247((String)"visit"))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)node);
        this.addAlias(root, (CommandNode<class_2168>)node, "is", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<class_2168>)node, "hs", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<class_2168>)node, "home", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)node, "house", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)node, "island", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)node, "plot", AliasCommandLevel.ALL);
    }

    private void addMessagingCommandNodes(RootCommandNode<class_2172> root) {
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"g").then((ArgumentBuilder)class_2170.method_9244((String)"msg", (ArgumentType)StringArgumentType.greedyString()))).build());
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"p").then((ArgumentBuilder)class_2170.method_9244((String)"msg", (ArgumentType)StringArgumentType.greedyString()))).build());
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"r").then((ArgumentBuilder)class_2170.method_9244((String)"msg", (ArgumentType)StringArgumentType.greedyString()))).build());
        LiteralCommandNode node = ((LiteralArgumentBuilder)class_2170.method_9247((String)"msg").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).then((ArgumentBuilder)class_2170.method_9244((String)"msg", (ArgumentType)StringArgumentType.greedyString())))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)node);
    }

    private void addMiscCommandNodes(RootCommandNode<class_2172> root) {
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"report").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER).then((ArgumentBuilder)class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString())))).build());
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"switch").then((ArgumentBuilder)class_2170.method_9244((String)"world", (ArgumentType)StringArgumentType.string()).suggests(SERVERS_SUGGESTION_PROVIDER))).build());
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"relore").then((ArgumentBuilder)class_2170.method_9244((String)"lore", (ArgumentType)StringArgumentType.greedyString()))).build());
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"dialogue").then((ArgumentBuilder)class_2170.method_9244((String)"option", (ArgumentType)IntegerArgumentType.integer()))).build());
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"thankyou").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER))).build());
        LiteralCommandNode renameitemNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"renameitem").then((ArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)renameitemNode);
        this.addAlias(root, (CommandNode<class_2168>)renameitemNode, "renameitems", AliasCommandLevel.ALL);
        LiteralCommandNode renamepetNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"renamepet").then((ArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)renamepetNode);
        this.addAlias(root, (CommandNode<class_2168>)renamepetNode, "renamepets", AliasCommandLevel.ALL);
        this.addNode(root, (CommandNode<? extends class_2172>)class_2170.method_9247((String)"ironman").build());
    }

    private void addParticlesCommandNode(RootCommandNode<class_2172> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"particles").then((ArgumentBuilder)class_2170.method_9247((String)"off"))).then((ArgumentBuilder)class_2170.method_9247((String)"low"))).then((ArgumentBuilder)class_2170.method_9247((String)"medium"))).then((ArgumentBuilder)class_2170.method_9247((String)"high"))).then((ArgumentBuilder)class_2170.method_9247((String)"veryhigh"))).then((ArgumentBuilder)class_2170.method_9247((String)"highest"))).then((ArgumentBuilder)class_2170.method_9247((String)"unlimited"))).then((ArgumentBuilder)class_2170.method_9244((String)"particles_per_tick", (ArgumentType)IntegerArgumentType.integer()))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)node);
        this.addAlias(root, (CommandNode<class_2168>)node, "pq", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<class_2168>)node, "particlequality", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)node, "particlesquality", AliasCommandLevel.ALL);
    }

    private void addPartyCommandNode(RootCommandNode<class_2172> root) {
        LiteralCommandNode node = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"party").then(class_2170.method_9247((String)"ban").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)class_2170.method_9247((String)"create"))).then((ArgumentBuilder)class_2170.method_9247((String)"disband"))).then((ArgumentBuilder)class_2170.method_9247((String)"finder"))).then(class_2170.method_9247((String)"invite").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"join").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"kick").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PARTY_NAME_SUGGESTION_PROVIDER)))).then((ArgumentBuilder)class_2170.method_9247((String)"leave"))).then((ArgumentBuilder)class_2170.method_9247((String)"lobby"))).then((ArgumentBuilder)class_2170.method_9247((String)"list"))).then(class_2170.method_9247((String)"promote").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PARTY_NAME_SUGGESTION_PROVIDER)))).then(class_2170.method_9247((String)"unban").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER)))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)node);
        this.addAlias(root, (CommandNode<class_2168>)node, "pa", AliasCommandLevel.SHORT_FORMS);
        this.addAlias(root, (CommandNode<class_2168>)node, "group", AliasCommandLevel.ALL);
    }

    private void addPlayerCommandNodes(RootCommandNode<class_2172> root) {
        LiteralCommandNode duelNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"duel").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)duelNode);
        this.addAlias(root, (CommandNode<class_2168>)duelNode, "d", AliasCommandLevel.SHORT_FORMS);
        LiteralCommandNode tradeNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"trade").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER))).build();
        this.addNode(root, (CommandNode<? extends class_2172>)tradeNode);
        this.addAlias(root, (CommandNode<class_2168>)tradeNode, "tr", AliasCommandLevel.SHORT_FORMS);
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)class_2170.method_9247((String)"find").then((ArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).suggests(PLAYER_NAME_SUGGESTION_PROVIDER))).build());
    }

    private void addToggleCommandNode(RootCommandNode<class_2172> root) {
        this.addNode(root, (CommandNode<? extends class_2172>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"toggle").then((ArgumentBuilder)class_2170.method_9247((String)"100"))).then((ArgumentBuilder)class_2170.method_9247((String)"autotracking"))).then((ArgumentBuilder)class_2170.method_9247((String)"beacon"))).then((ArgumentBuilder)class_2170.method_9247((String)"blood"))).then((ArgumentBuilder)class_2170.method_9247((String)"bombbell"))).then((ArgumentBuilder)class_2170.method_9247((String)"combatbar"))).then((ArgumentBuilder)class_2170.method_9247((String)"friendpopups"))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ghosts").then((ArgumentBuilder)class_2170.method_9247((String)"none"))).then((ArgumentBuilder)class_2170.method_9247((String)"low"))).then((ArgumentBuilder)class_2170.method_9247((String)"medium"))).then((ArgumentBuilder)class_2170.method_9247((String)"high"))).then((ArgumentBuilder)class_2170.method_9247((String)"all")))).then((ArgumentBuilder)class_2170.method_9247((String)"guildjoin"))).then((ArgumentBuilder)class_2170.method_9247((String)"guildpopups"))).then((ArgumentBuilder)class_2170.method_9247((String)"insults"))).then((ArgumentBuilder)class_2170.method_9247((String)"music"))).then((ArgumentBuilder)class_2170.method_9247((String)"outlines"))).then((ArgumentBuilder)class_2170.method_9247((String)"popups"))).then((ArgumentBuilder)class_2170.method_9247((String)"pouchmsg"))).then((ArgumentBuilder)class_2170.method_9247((String)"pouchpickup"))).then((ArgumentBuilder)class_2170.method_9247((String)"queststartbeacon"))).then((ArgumentBuilder)class_2170.method_9247((String)"sb"))).then((ArgumentBuilder)class_2170.method_9247((String)"swears"))).then((ArgumentBuilder)class_2170.method_9247((String)"war"))).build());
    }

    private void addDeprecatedCommandNodes(RootCommandNode<class_2172> root) {
        LiteralCommandNode legacystoreNode = class_2170.method_9247((String)"legacystore").build();
        this.addNode(root, (CommandNode<? extends class_2172>)legacystoreNode);
        this.addAlias(root, (CommandNode<class_2168>)legacystoreNode, "buy", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)legacystoreNode, "cash", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)legacystoreNode, "cashshop", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)legacystoreNode, "gc", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)legacystoreNode, "gold", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)legacystoreNode, "goldcoins", AliasCommandLevel.ALL);
        this.addAlias(root, (CommandNode<class_2168>)legacystoreNode, "goldshop", AliasCommandLevel.ALL);
        LiteralCommandNode renameNode = class_2170.method_9247((String)"rename").build();
        this.addNode(root, (CommandNode<? extends class_2172>)renameNode);
        this.addAlias(root, (CommandNode<class_2168>)renameNode, "name", AliasCommandLevel.ALL);
    }

    public static enum AliasCommandLevel {
        NONE,
        SHORT_FORMS,
        ALL;

    }
}

