/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.InventoryKeyPressEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.mc.extension.ScreenExtension;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.ContentBookContainer;
import com.wynntils.models.containers.containers.CosmeticContainer;
import com.wynntils.models.containers.containers.GuildBadgesContainer;
import com.wynntils.models.containers.containers.GuildBankContainer;
import com.wynntils.models.containers.containers.GuildMemberListContainer;
import com.wynntils.models.containers.containers.GuildTerritoriesContainer;
import com.wynntils.models.containers.containers.HousingJukeboxContainer;
import com.wynntils.models.containers.containers.HousingListContainer;
import com.wynntils.models.containers.containers.JukeboxContainer;
import com.wynntils.models.containers.containers.personal.AccountBankContainer;
import com.wynntils.models.containers.containers.personal.BookshelfContainer;
import com.wynntils.models.containers.containers.personal.CharacterBankContainer;
import com.wynntils.models.containers.containers.personal.IslandBlockBankContainer;
import com.wynntils.models.containers.containers.personal.MiscBucketContainer;
import com.wynntils.models.containers.containers.personal.PersonalBlockBankContainer;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.containers.type.SearchableContainerProperty;
import com.wynntils.models.items.WynnItem;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.ItemFilterUIButton;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class ContainerSearchFeature
extends Feature {
    @Persisted
    private final Config<Boolean> filterInBank = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInBlockBank = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInBookshelf = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInMiscBucket = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInGuildBank = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInGuildMemberList = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInCosmeticMenus = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInContentBook = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInGuildTerritories = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInGuildBadges = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInHousingJukebox = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInHousingList = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInJukebox = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> highlightColor = new Config<CustomColor>(CommonColors.MAGENTA);
    private final Map<Class<? extends SearchableContainerProperty>, Supplier<Boolean>> searchableContainerMap;
    private static final int GUILD_BANK_SEARCH_DELAY = 500;
    private long guildBankLastSearch;
    private SearchWidget lastSearchWidget;
    private SearchableContainerProperty currentContainer;
    private boolean autoSearching;
    private boolean matchedItems;
    private int direction;
    private ItemSearchQuery lastSearchQuery;

    public ContainerSearchFeature() {
        Map.Entry[] entryArray = new Map.Entry[15];
        entryArray[0] = Map.entry(AccountBankContainer.class, this.filterInBank::get);
        entryArray[1] = Map.entry(BookshelfContainer.class, this.filterInBookshelf::get);
        entryArray[2] = Map.entry(CharacterBankContainer.class, this.filterInBank::get);
        entryArray[3] = Map.entry(ContentBookContainer.class, this.filterInContentBook::get);
        entryArray[4] = Map.entry(GuildBankContainer.class, this.filterInGuildBank::get);
        entryArray[5] = Map.entry(GuildBadgesContainer.class, this.filterInGuildBadges::get);
        entryArray[6] = Map.entry(GuildMemberListContainer.class, this.filterInGuildMemberList::get);
        entryArray[7] = Map.entry(GuildTerritoriesContainer.class, this.filterInGuildTerritories::get);
        entryArray[8] = Map.entry(HousingJukeboxContainer.class, this.filterInHousingJukebox::get);
        entryArray[9] = Map.entry(HousingListContainer.class, this.filterInHousingList::get);
        entryArray[10] = Map.entry(IslandBlockBankContainer.class, this.filterInBlockBank::get);
        entryArray[11] = Map.entry(JukeboxContainer.class, this.filterInJukebox::get);
        entryArray[12] = Map.entry(MiscBucketContainer.class, this.filterInMiscBucket::get);
        entryArray[13] = Map.entry(PersonalBlockBankContainer.class, this.filterInBlockBank::get);
        entryArray[14] = Map.entry(CosmeticContainer.class, this.filterInCosmeticMenus::get);
        this.searchableContainerMap = Map.ofEntries(entryArray);
        this.guildBankLastSearch = 0L;
        this.autoSearching = false;
        this.matchedItems = false;
        this.direction = 0;
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        class_437 class_4372 = event.getScreen();
        if (!(class_4372 instanceof class_465)) {
            return;
        }
        class_465 screen = (class_465)class_4372;
        if (!(screen.method_17577() instanceof class_1707)) {
            return;
        }
        int renderX = (screen.field_22789 - screen.field_2792) / 2;
        int renderY = (screen.field_22790 - screen.field_2779) / 2;
        this.currentContainer = this.getCurrentSearchableContainer();
        if (this.currentContainer == null) {
            return;
        }
        this.matchedItems = false;
        SearchableContainerProperty searchableContainerProperty = this.currentContainer;
        if (searchableContainerProperty instanceof SearchableContainerProperty) {
            SearchableContainerProperty searchableContainer = searchableContainerProperty;
            renderY -= searchableContainer.renderYOffset();
        }
        this.addWidgets((class_465<class_1707>)screen, renderX, renderY);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderSlot(SlotRenderEvent.CountPre e) {
        class_1799 itemStack = e.getSlot().method_7677();
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        Boolean result = (Boolean)wynnItemOpt.get().getData().get("searched");
        if (result == null || !result.booleanValue()) {
            return;
        }
        RenderSystem.enableDepthTest();
        RenderUtils.drawArc(e.getPoseStack(), (CustomColor)this.highlightColor.get(), e.getSlot().field_7873, e.getSlot().field_7872, 100.0f, 1.0f, 6, 8);
        RenderSystem.disableDepthTest();
    }

    @SubscribeEvent
    public void onContainerSetContent(ContainerSetContentEvent.Post event) {
        class_437 class_4372;
        if (this.currentContainer == null) {
            return;
        }
        this.forceUpdateSearch();
        if (!this.matchedItems && this.autoSearching && (class_4372 = McUtils.screen()) instanceof class_465) {
            class_465 abstractContainerScreen = (class_465)class_4372;
            this.tryAutoSearch(abstractContainerScreen);
        }
    }

    @SubscribeEvent
    public void onContainerSetSlot(ContainerSetSlotEvent.Pre event) {
        if (this.currentContainer == null) {
            return;
        }
        this.forceUpdateSearch();
    }

    @SubscribeEvent
    public void onSlotClicked(ContainerClickEvent e) {
        this.autoSearching = false;
    }

    @SubscribeEvent
    public void onContainerClose(ContainerCloseEvent.Post event) {
        this.lastSearchWidget = null;
        this.lastSearchQuery = null;
        this.currentContainer = null;
        this.autoSearching = false;
        this.matchedItems = false;
        this.direction = 0;
        this.guildBankLastSearch = 0L;
    }

    @SubscribeEvent
    public void onInventoryKeyPress(InventoryKeyPressEvent event) {
        if (event.getKeyCode() == 257 && !Models.Bank.isEditingMode()) {
            class_465 abstractContainerScreen;
            class_437 class_4372;
            if (this.lastSearchWidget == null || this.lastSearchWidget.getTextBoxInput().isEmpty() || this.currentContainer == null || !((class_4372 = McUtils.screen()) instanceof class_465) || !((class_4372 = (abstractContainerScreen = (class_465)class_4372).method_17577()) instanceof class_1707)) {
                return;
            }
            class_1707 chestMenu = (class_1707)class_4372;
            abstractContainerScreen.method_48267();
            TextboxScreen textboxScreen = (TextboxScreen)abstractContainerScreen;
            textboxScreen.setFocusedTextInput(null);
            this.direction = 1;
            StyledText nextItemName = StyledText.fromComponent(((class_1799)chestMenu.method_7602().get(this.currentContainer.getNextItemSlot())).method_7964());
            if (!nextItemName.matches(this.currentContainer.getNextItemPattern())) {
                this.direction = -1;
            }
            if (abstractContainerScreen.field_2787 != null) {
                if (abstractContainerScreen.field_2787.field_7874 == this.currentContainer.getNextItemSlot()) {
                    this.direction = 1;
                } else if (abstractContainerScreen.field_2787.field_7874 == this.currentContainer.getPreviousItemSlot()) {
                    this.direction = -1;
                }
            }
            this.autoSearching = true;
            if (KeyboardUtils.isShiftDown() && this.currentContainer instanceof PersonalStorageContainer) {
                ContainerUtils.pressKeyOnSlot(7, abstractContainerScreen.method_17577().field_7763, 0, (List<class_1799>)abstractContainerScreen.method_17577().method_7602());
                return;
            }
            this.tryAutoSearch(abstractContainerScreen);
        }
    }

    private void tryAutoSearch(class_465<?> abstractContainerScreen) {
        Pattern itemPattern;
        if (!this.autoSearching) {
            return;
        }
        if (this.currentContainer instanceof GuildBankContainer) {
            long diff = System.currentTimeMillis() - this.guildBankLastSearch;
            if (diff < 500L) {
                Managers.TickScheduler.scheduleLater(() -> this.tryAutoSearch(abstractContainerScreen), (int)(500L - diff) / 50);
                return;
            }
            this.guildBankLastSearch = System.currentTimeMillis();
        }
        int slot = this.direction == 1 ? this.currentContainer.getNextItemSlot() : this.currentContainer.getPreviousItemSlot();
        StyledText name = StyledText.fromComponent(((class_1799)abstractContainerScreen.method_17577().method_7602().get(slot)).method_7964());
        Pattern pattern = itemPattern = this.direction == 1 ? this.currentContainer.getNextItemPattern() : this.currentContainer.getPreviousItemPattern();
        if (!name.matches(itemPattern)) {
            this.autoSearching = false;
            return;
        }
        ContainerUtils.clickOnSlot(slot, abstractContainerScreen.method_17577().field_7763, 0, (List<class_1799>)abstractContainerScreen.method_17577().method_7602());
    }

    private SearchableContainerProperty getCurrentSearchableContainer() {
        Container container = Models.Container.getCurrentContainer();
        if (container instanceof SearchableContainerProperty) {
            SearchableContainerProperty searchableContainer = (SearchableContainerProperty)((Object)container);
            for (Map.Entry entry : this.searchableContainerMap.entrySet()) {
                if (!((Class)entry.getKey()).isInstance(searchableContainer) || !((Boolean)((Supplier)entry.getValue()).get()).booleanValue()) continue;
                return searchableContainer;
            }
        }
        return null;
    }

    private void addWidgets(class_465<class_1707> screen, int renderX, int renderY) {
        if (this.currentContainer.supportsAdvancedSearch()) {
            ItemSearchWidget searchWidget = new ItemSearchWidget(renderX + screen.field_2792 - 175, renderY - 20, 155, 20, this.currentContainer.supportedProviderTypes(), false, query -> {
                this.lastSearchQuery = query;
                this.matchItemsAdvanced(this.lastSearchQuery, (class_1707)screen.method_17577());
            }, (ScreenExtension)screen);
            if (this.lastSearchWidget != null) {
                searchWidget.setTextBoxInput(this.lastSearchWidget.getTextBoxInput());
            }
            this.lastSearchWidget = searchWidget;
            screen.method_37063((class_364)this.lastSearchWidget);
            screen.method_37063((class_364)new ItemFilterUIButton(renderX + 157, renderY - 20, this.lastSearchWidget, (class_437)screen, false, this.currentContainer.supportedProviderTypes()));
        } else {
            SearchWidget searchWidget = new SearchWidget(renderX + screen.field_2792 - 175, renderY - 20, 175, 20, s -> this.matchItemsBasic((String)s, (class_1707)screen.method_17577()), (ScreenExtension)screen);
            if (this.lastSearchWidget != null) {
                searchWidget.setTextBoxInput(this.lastSearchWidget.getTextBoxInput());
            }
            this.lastSearchWidget = searchWidget;
            screen.method_37063((class_364)this.lastSearchWidget);
        }
    }

    private void matchItemsAdvanced(ItemSearchQuery searchQuery, class_1707 chestMenu) {
        this.matchedItems = false;
        if (searchQuery == null) {
            return;
        }
        class_1263 container = chestMenu.method_7629();
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 itemStack;
            Optional<WynnItem> wynnItemOpt;
            if (!this.currentContainer.getBounds().getSlots().contains(i) || (wynnItemOpt = Models.Item.getWynnItem(itemStack = container.method_5438(i))).isEmpty()) continue;
            boolean filtered = !searchQuery.isEmpty() && Services.ItemFilter.matches(searchQuery, itemStack);
            wynnItemOpt.get().getData().store("searched", filtered);
            if (!filtered) continue;
            this.matchedItems = true;
        }
    }

    private void matchItemsBasic(String searchStr, class_1707 chestMenu) {
        String search = searchStr.toLowerCase(Locale.ROOT);
        this.matchedItems = false;
        class_1263 container = chestMenu.method_7629();
        for (int i = 0; i < container.method_5439(); ++i) {
            class_1799 itemStack;
            Optional<WynnItem> wynnItemOpt;
            if (!this.currentContainer.getBounds().getSlots().contains(i) || (wynnItemOpt = Models.Item.getWynnItem(itemStack = container.method_5438(i))).isEmpty()) continue;
            String name = StyledText.fromComponent(itemStack.method_7964()).getStringWithoutFormatting().toLowerCase(Locale.ROOT);
            boolean filtered = !search.isEmpty() && name.contains(search) && !itemStack.method_7960();
            wynnItemOpt.get().getData().store("searched", filtered);
            if (!filtered) continue;
            this.matchedItems = true;
        }
    }

    private void forceUpdateSearch() {
        class_465 abstractContainerScreen;
        class_1703 class_17032;
        class_437 screen = McUtils.screen();
        if (this.lastSearchWidget != null && screen instanceof class_465 && (class_17032 = (abstractContainerScreen = (class_465)screen).method_17577()) instanceof class_1707) {
            class_1707 chestMenu = (class_1707)class_17032;
            if (this.currentContainer.supportsAdvancedSearch()) {
                this.matchItemsAdvanced(this.lastSearchQuery, chestMenu);
            } else {
                this.matchItemsBasic(this.lastSearchWidget.getTextBoxInput(), chestMenu);
            }
        }
    }
}

