/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.HotbarSlotRenderEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class EmeraldPouchFillArcFeature
extends Feature {
    @Persisted
    private final Config<Boolean> renderFillArcHotbar = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> renderFillArcInventory = new Config<Boolean>(true);

    @SubscribeEvent
    public void onRenderHotbarSlot(HotbarSlotRenderEvent.CountPre e) {
        if (!((Boolean)this.renderFillArcHotbar.get()).booleanValue()) {
            return;
        }
        this.drawFilledArc(e.getPoseStack(), e.getItemStack(), e.getX(), e.getY());
    }

    @SubscribeEvent
    public void onRenderSlot(SlotRenderEvent.CountPre e) {
        if (!((Boolean)this.renderFillArcInventory.get()).booleanValue()) {
            return;
        }
        this.drawFilledArc(e.getPoseStack(), e.getSlot().method_7677(), e.getSlot().field_7873, e.getSlot().field_7872);
    }

    private void drawFilledArc(class_4587 poseStack, class_1799 itemStack, int slotX, int slotY) {
        Optional<EmeraldPouchItem> optionalItem = Models.Item.asWynnItem(itemStack, EmeraldPouchItem.class);
        if (optionalItem.isEmpty()) {
            return;
        }
        CappedValue capacity = new CappedValue(optionalItem.get().getValue(), optionalItem.get().getCapacity());
        float capacityFraction = (float)capacity.current() / (float)capacity.max();
        int colorInt = class_3532.method_15369((float)((1.0f - capacityFraction) / 3.0f), (float)1.0f, (float)1.0f);
        CustomColor color = CustomColor.fromInt(colorInt).withAlpha(160);
        float ringFraction = Math.min(1.0f, capacityFraction);
        RenderSystem.enableDepthTest();
        RenderUtils.drawArc(poseStack, color, slotX - 2, slotY - 2, 100.0f, ringFraction, 8, 10);
        RenderSystem.disableDepthTest();
    }
}

