/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerRenderEvent;
import com.wynntils.models.containers.containers.reward.LootChestContainer;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.class_4587;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class LootchestTextFeature
extends Feature {
    @Persisted
    private final Config<String> titleTextTemplate = new Config<String>("\u00a78Total: {chest_opened}");
    @Persisted
    private final Config<String> inventoryTextTemplate = new Config<String>("\u00a78Dry: {dry_streak}");

    @SubscribeEvent
    public void onRenderLootChest(ContainerRenderEvent event) {
        if (!(Models.Container.getCurrentContainer() instanceof LootChestContainer)) {
            return;
        }
        int startX = event.getScreen().field_2776;
        int startY = event.getScreen().field_2800;
        int width = event.getScreen().field_2792;
        int titleLabelX = event.getScreen().field_25267;
        int titleLabelY = event.getScreen().field_25268;
        int inventoryLabelX = event.getScreen().field_25269;
        int inventoryLabelY = event.getScreen().field_25270;
        class_4587 poseStack = event.getPoseStack();
        poseStack.method_22903();
        poseStack.method_46416((float)startX, (float)startY, 200.0f);
        this.renderTitleTemplate(event.getPoseStack(), width - titleLabelX, titleLabelY);
        this.renderInventoryTemplate(event.getPoseStack(), width - inventoryLabelX, inventoryLabelY);
        poseStack.method_22909();
    }

    private void renderTitleTemplate(class_4587 poseStack, int x, int y) {
        String titleTemplateResult = Arrays.stream(Managers.Function.doFormatLines((String)this.titleTextTemplate.get())).map(StyledText::getString).collect(Collectors.joining(" "));
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(titleTemplateResult), (float)x, (float)y, 0.0f, CommonColors.WHITE, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, TextShadow.NONE);
    }

    private void renderInventoryTemplate(class_4587 poseStack, int x, int y) {
        String inventoryTemplateResult = Arrays.stream(Managers.Function.doFormatLines((String)this.inventoryTextTemplate.get())).map(StyledText::getString).collect(Collectors.joining(" "));
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(inventoryTemplateResult), (float)x, (float)y, 0.0f, CommonColors.WHITE, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, TextShadow.NONE);
    }
}

