/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.map;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.RenderTileLevelLastEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import java.util.List;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_822;
import net.minecraft.class_9799;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.MAP)
public class BeaconBeamFeature
extends Feature {
    private static final class_4597.class_4598 BUFFER_SOURCE = class_4597.method_22991((class_9799)new class_9799(256));
    @Persisted
    private final Config<CustomColor> waypointBeamColor = new Config<CustomColor>(CommonColors.RED);
    private static final int RAINBOW_CHANGE_RATE = 10;
    private CustomColor currentRainbowColor = CommonColors.RED;

    @SubscribeEvent
    public void onTick(TickEvent event) {
        int r = this.currentRainbowColor.r();
        int g = this.currentRainbowColor.g();
        int b = this.currentRainbowColor.b();
        if (r > 0 && b == 0) {
            r -= 10;
            g += 10;
        }
        if (g > 0 && r == 0) {
            g -= 10;
            b += 10;
        }
        if (b > 0 && g == 0) {
            r += 10;
            b -= 10;
        }
        r = MathUtils.clamp(r, 0, 255);
        g = MathUtils.clamp(g, 0, 255);
        b = MathUtils.clamp(b, 0, 255);
        this.currentRainbowColor = new CustomColor(r, g, b, 255);
    }

    @SubscribeEvent
    public void onRenderLevelLast(RenderTileLevelLastEvent event) {
        List<MarkerInfo> markers = Models.Marker.getAllMarkers().toList();
        if (markers.isEmpty()) {
            return;
        }
        class_4587 poseStack = event.getPoseStack();
        for (MarkerInfo marker : markers) {
            int maxDistance;
            class_243 camera = event.getCamera().method_19326();
            Location location = marker.location();
            double dx = (double)location.x - camera.method_10216();
            double dy = (double)location.y - camera.method_10214();
            double dz = (double)location.z - camera.method_10215();
            double distance = MathUtils.magnitude(dx, dz);
            if (distance > (double)(maxDistance = (Integer)McUtils.options().method_42503().method_41753() * 16)) {
                double scale = (double)maxDistance / distance;
                dx *= scale;
                dz *= scale;
            }
            float alpha = 1.0f;
            if (distance <= 7.0) {
                alpha = MathUtils.clamp(MathUtils.map((float)distance, 2.0f, 7.0f, 0.0f, 1.0f), 0.0f, 1.0f);
            }
            poseStack.method_22903();
            poseStack.method_22904(dx, dy, dz);
            CustomColor color = marker.beaconColor() == CustomColor.NONE ? (CustomColor)this.waypointBeamColor.get() : marker.beaconColor();
            int colorInt = color == CommonColors.RAINBOW ? this.currentRainbowColor.withAlpha(alpha).asInt() : color.withAlpha(alpha).asInt();
            class_822.method_3545((class_4587)poseStack, (class_4597)BUFFER_SOURCE, (class_2960)class_822.field_4338, (float)event.getDeltaTracker().method_60637(false), (float)1.0f, (long)McUtils.player().method_37908().method_8510(), (int)0, (int)1024, (int)colorInt, (float)0.166f, (float)0.33f);
            poseStack.method_22909();
        }
        BUFFER_SOURCE.method_37104();
    }
}

