/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.overlays;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.annotations.OverlayInfo;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.models.war.event.GuildWarTowerEffectEvent;
import com.wynntils.overlays.TowerAuraTimerOverlay;
import com.wynntils.overlays.TowerVolleyTimerOverlay;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.OVERLAYS)
public class TowerEffectOverlayFeature
extends Feature {
    private static final class_3414 AURA_SOUND = class_3417.field_14833;
    private static final class_3414 VOLLEY_SOUND = class_3417.field_14970;
    @OverlayInfo(renderType=RenderEvent.ElementType.GUI)
    private final Overlay auraTimerOverlay = new TowerAuraTimerOverlay();
    @OverlayInfo(renderType=RenderEvent.ElementType.GUI)
    private final Overlay volleyTimerOverlay = new TowerVolleyTimerOverlay();
    @Persisted
    private final Config<Boolean> soundEffectAura = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> soundEffectVolley = new Config<Boolean>(false);
    @Persisted
    private final Config<Float> soundVolume = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<Float> soundPitch = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<Boolean> vignetteOnAura = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> vignetteOnVolley = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> auraVignetteColor = new Config<CustomColor>(CommonColors.ORANGE);
    @Persisted
    private final Config<CustomColor> volleyVignetteColor = new Config<CustomColor>(CommonColors.MAGENTA);
    @Persisted
    private final Config<Float> auraVignetteIntensity = new Config<Float>(Float.valueOf(0.4f));
    @Persisted
    private final Config<Float> volleyVignetteIntensity = new Config<Float>(Float.valueOf(0.4f));

    @SubscribeEvent
    public void onTowerAura(GuildWarTowerEffectEvent.AuraSpawned event) {
        if (!((Boolean)this.soundEffectAura.get()).booleanValue()) {
            return;
        }
        McUtils.playSoundAmbient(AURA_SOUND, ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
    }

    @SubscribeEvent
    public void onTowerVolley(GuildWarTowerEffectEvent.VolleySpawned event) {
        if (!((Boolean)this.soundEffectVolley.get()).booleanValue()) {
            return;
        }
        McUtils.playSoundAmbient(VOLLEY_SOUND, ((Float)this.soundVolume.get()).floatValue(), ((Float)this.soundPitch.get()).floatValue());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderGui(RenderEvent.Post event) {
        if (event.getType() != RenderEvent.ElementType.GUI) {
            return;
        }
        if (((Boolean)this.vignetteOnAura.get()).booleanValue()) {
            this.renderAuraVignette(event.getPoseStack());
        }
        if (((Boolean)this.vignetteOnVolley.get()).booleanValue()) {
            this.renderVolleyVignette(event.getPoseStack());
        }
    }

    private void renderAuraVignette(class_4587 poseStack) {
        long remainingTimeUntilAura = Models.GuildWarTower.getRemainingTimeUntilAura();
        if (remainingTimeUntilAura <= 0L) {
            return;
        }
        RenderUtils.renderVignetteOverlay(poseStack, (CustomColor)this.auraVignetteColor.get(), MathUtils.map(remainingTimeUntilAura, Models.GuildWarTower.getEffectLength(), 0.0f, 0.0f, ((Float)this.auraVignetteIntensity.get()).floatValue()));
    }

    private void renderVolleyVignette(class_4587 poseStack) {
        long remainingTimeUntilVolley = Models.GuildWarTower.getRemainingTimeUntilVolley();
        if (remainingTimeUntilVolley <= 0L) {
            return;
        }
        RenderUtils.renderVignetteOverlay(poseStack, (CustomColor)this.volleyVignetteColor.get(), MathUtils.map(remainingTimeUntilVolley, Models.GuildWarTower.getEffectLength(), 0.0f, 0.0f, ((Float)this.volleyVignetteIntensity.get()).floatValue()));
    }
}

