/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.players;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.hades.protocol.enums.SocialType;

@ConfigCategory(value=Category.PLAYERS)
public class HadesFeature
extends Feature {
    @Persisted
    public final Config<Boolean> getOtherPlayerInfo = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> shareWithParty = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> shareWithFriends = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> shareWithGuild = new Config<Boolean>(true);

    @Override
    protected void onConfigUpdate(Config<?> config) {
        switch (config.getFieldName()) {
            case "getOtherPlayerInfo": {
                if (((Boolean)this.getOtherPlayerInfo.get()).booleanValue()) {
                    Services.Hades.tryResendWorldData();
                    break;
                }
                Services.Hades.resetHadesUsers();
                break;
            }
            case "shareWithParty": {
                if (((Boolean)this.shareWithParty.get()).booleanValue()) {
                    Models.Party.requestData();
                    break;
                }
                Services.Hades.resetSocialType(SocialType.PARTY);
                break;
            }
            case "shareWithFriends": {
                if (((Boolean)this.shareWithFriends.get()).booleanValue()) {
                    Models.Friends.requestData();
                    break;
                }
                Services.Hades.resetSocialType(SocialType.FRIEND);
                break;
            }
            case "shareWithGuild": {
                if (((Boolean)this.shareWithGuild.get()).booleanValue()) {
                    Models.Guild.requestGuildMembers();
                    break;
                }
                Services.Hades.resetSocialType(SocialType.GUILD);
            }
        }
    }
}

