/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.tooltips;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.handlers.tooltip.type.TooltipWeightDecorator;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.models.gear.type.ItemWeightSource;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.NamedItemProperty;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatListOrdering;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.stats.type.StatUnit;
import com.wynntils.services.itemweight.type.ItemWeighting;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.TooltipUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.wynn.ColorScaleUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.TOOLTIPS)
public class ItemStatInfoFeature
extends Feature {
    private final Map<IdentificationDecoratorType, TooltipIdentificationDecorator> identificationDecorators = Map.of(IdentificationDecoratorType.PERCENTAGE, new PercentageIdentificationDecorator(), IdentificationDecoratorType.REROLL, new RerollIdentificationDecorator(), IdentificationDecoratorType.RANGE, new RangeIdentificationDecorator(), IdentificationDecoratorType.INNER_ROLL, new InnerRollIdentificationDecorator());
    private final Map<WeightDecoratorType, TooltipWeightDecorator> weightDecorators = Map.of(WeightDecoratorType.OVERALL, new SimpleWeightDecorator(), WeightDecoratorType.FULL, new FullWeightDecorator());
    private final Set<WynnItem> brokenItems = new HashSet<WynnItem>();
    @Persisted
    public final Config<Boolean> showStars = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> colorLerp = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> legacyColors = new Config<Boolean>(false);
    @Persisted
    private final Config<ColorThreshold> perfectColorThreshold = new Config<ColorThreshold>(ColorThreshold.NINETY_FIVE);
    @Persisted
    public final Config<Integer> decimalPlaces = new Config<Integer>(1);
    @Persisted
    public final Config<Boolean> perfect = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> defective = new Config<Boolean>(true);
    @Persisted
    public final Config<Float> obfuscationChanceStart = new Config<Float>(Float.valueOf(0.08f));
    @Persisted
    public final Config<Float> obfuscationChanceEnd = new Config<Float>(Float.valueOf(0.04f));
    @Persisted
    public final Config<StatListOrdering> identificationsOrdering = new Config<StatListOrdering>(StatListOrdering.DEFAULT);
    @Persisted
    public final Config<Boolean> groupIdentifications = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> identificationDecorations = new Config<Boolean>(true);
    @Persisted
    public final Config<ItemWeightSource> itemWeights = new Config<ItemWeightSource>(ItemWeightSource.NONE);
    @Persisted
    public final Config<Boolean> overallPercentageInName = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> showBestValueLastAlways = new Config<Boolean>(true);
    @Persisted
    public final Config<Boolean> showMaxValues = new Config<Boolean>(true);
    private static final NavigableMap<Float, class_5251> LERP_MAP = new TreeMap<Float, class_5251>(Map.of(Float.valueOf(0.0f), class_5251.method_27718((class_124)class_124.field_1061), Float.valueOf(40.0f), class_5251.method_27718((class_124)class_124.field_1065), Float.valueOf(70.0f), class_5251.method_27718((class_124)class_124.field_1054), Float.valueOf(90.0f), class_5251.method_27718((class_124)class_124.field_1060), Float.valueOf(100.0f), class_5251.method_27718((class_124)class_124.field_1075)));
    private NavigableMap<Float, class_5251> flatMap = this.createFlatMap();

    @Override
    protected void onConfigUpdate(Config<?> config) {
        if (config == this.legacyColors || config == this.perfectColorThreshold) {
            this.flatMap = this.createFlatMap();
        }
    }

    @SubscribeEvent
    public void onTooltipPre(ItemTooltipRenderEvent.Pre event) {
        block7: {
            if (KeyboardUtils.isKeyDown(344)) {
                return;
            }
            class_1799 itemStack = event.getItemStack();
            Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
            if (wynnItemOpt.isEmpty()) {
                return;
            }
            WynnItem wynnItem = wynnItemOpt.get();
            if (this.brokenItems.contains(wynnItem)) {
                return;
            }
            try {
                List<class_2561> tooltips = TooltipUtils.getWynnItemTooltip(itemStack, wynnItem);
                if (tooltips.isEmpty()) {
                    return;
                }
                event.setTooltips(tooltips);
            }
            catch (Exception e) {
                this.brokenItems.add(wynnItem);
                String itemName = wynnItem.getClass().getSimpleName();
                Optional<NamedItemProperty> namedItemPropertyOpt = Models.Item.asWynnItemProperty(event.getItemStack(), NamedItemProperty.class);
                if (namedItemPropertyOpt.isPresent()) {
                    itemName = namedItemPropertyOpt.get().getName();
                }
                WynntilsMod.error("Exception when creating tooltips for item " + itemName, e);
                WynntilsMod.warn("This item has been disabled from ItemStatInfoFeature: " + String.valueOf(wynnItem));
                McUtils.sendErrorToClient("Wynntils error: Problem showing tooltip for item " + itemName);
                if (this.brokenItems.size() <= 10) break block7;
                throw new RuntimeException(e);
            }
        }
    }

    public NavigableMap<Float, class_5251> getColorMap() {
        return (Boolean)this.colorLerp.get() != false ? LERP_MAP : this.flatMap;
    }

    public TooltipIdentificationDecorator getIdentificationDecorator() {
        return this.identificationDecorators.get((Object)IdentificationDecoratorType.getCurrentType());
    }

    public TooltipWeightDecorator getWeightDecorator() {
        return this.weightDecorators.get((Object)WeightDecoratorType.getCurrentType());
    }

    private NavigableMap<Float, class_5251> createFlatMap() {
        boolean useLegacyColors = (Boolean)this.legacyColors.get();
        float redThreshold = useLegacyColors ? 30.0f : 20.0f;
        float aquaThreshold = ((ColorThreshold)((Object)this.perfectColorThreshold.get())).getThreshold();
        TreeMap<Float, class_5251> map = new TreeMap<Float, class_5251>();
        map.put(Float.valueOf(redThreshold), class_5251.method_27718((class_124)class_124.field_1061));
        if (!useLegacyColors) {
            map.put(Float.valueOf(50.0f), class_5251.method_27718((class_124)class_124.field_1065));
        }
        map.put(Float.valueOf(80.0f), class_5251.method_27718((class_124)class_124.field_1054));
        map.put(Float.valueOf(aquaThreshold), class_5251.method_27718((class_124)class_124.field_1060));
        map.put(Float.valueOf(Float.MAX_VALUE), class_5251.method_27718((class_124)class_124.field_1075));
        return map;
    }

    private static enum IdentificationDecoratorType {
        INNER_ROLL(Set.of(Integer.valueOf(340), Integer.valueOf(341))),
        REROLL(Set.of(Integer.valueOf(341))),
        RANGE(Set.of(Integer.valueOf(340))),
        PERCENTAGE(Set.of());

        private final Set<Integer> keyCodes;

        private IdentificationDecoratorType(Set<Integer> keyCodes) {
            this.keyCodes = keyCodes;
        }

        public static IdentificationDecoratorType getCurrentType() {
            for (IdentificationDecoratorType type : IdentificationDecoratorType.values()) {
                if (!type.keyCodes.stream().allMatch(KeyboardUtils::isKeyDown)) continue;
                return type;
            }
            return PERCENTAGE;
        }
    }

    private class PercentageIdentificationDecorator
    extends IdentificationDecorator {
        private PercentageIdentificationDecorator() {
        }

        @Override
        protected class_5250 getRollSuffix(TooltipStyle style, StatActualValue actualValue, StatPossibleValues possibleValues) {
            float percentage = StatCalculator.getPercentage(actualValue, possibleValues);
            class_5250 percentageTextComponent = ColorScaleUtils.getPercentageTextComponent(ItemStatInfoFeature.this.getColorMap(), percentage, (Boolean)ItemStatInfoFeature.this.colorLerp.get(), (Integer)ItemStatInfoFeature.this.decimalPlaces.get());
            return percentageTextComponent;
        }
    }

    private static class RerollIdentificationDecorator
    extends IdentificationDecorator {
        private RerollIdentificationDecorator() {
        }

        @Override
        protected class_5250 getRollSuffix(TooltipStyle style, StatActualValue actualValue, StatPossibleValues possibleValues) {
            class_5250 rerollChancesComponent = class_2561.method_43470((String)String.format(Locale.ROOT, " \u2605%.2f%%", StatCalculator.getPerfectChance(possibleValues))).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, " \u21e7%.1f%%", StatCalculator.getIncreaseChance(actualValue, possibleValues))).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)String.format(Locale.ROOT, " \u21e9%.1f%%", StatCalculator.getDecreaseChance(actualValue, possibleValues))).method_27692(class_124.field_1061));
            return rerollChancesComponent;
        }
    }

    private static class RangeIdentificationDecorator
    extends IdentificationDecorator {
        private RangeIdentificationDecorator() {
        }

        @Override
        protected class_5250 getRollSuffix(TooltipStyle style, StatActualValue actualValue, StatPossibleValues possibleValues) {
            Pair<Integer, Integer> displayRange = StatCalculator.getDisplayRange(possibleValues, style.showBestValueLastAlways());
            class_5250 rangeTextComponent = class_2561.method_43470((String)" [").method_10852((class_2561)class_2561.method_43470((String)(String.valueOf(displayRange.a()) + ", " + String.valueOf(displayRange.b()))).method_27692(class_124.field_1060)).method_27693("]").method_27692(class_124.field_1077);
            return rangeTextComponent;
        }
    }

    private static class InnerRollIdentificationDecorator
    extends IdentificationDecorator {
        private InnerRollIdentificationDecorator() {
        }

        @Override
        protected class_5250 getRollSuffix(TooltipStyle style, StatActualValue actualValue, StatPossibleValues possibleValues) {
            class_5250 rangeTextComponent = class_2561.method_43470((String)" <").method_10852((class_2561)class_2561.method_43470((String)(actualValue.internalRoll().low() + "% to " + actualValue.internalRoll().high() + "%")).method_27692(class_124.field_1060)).method_27693(">").method_27692(class_124.field_1077);
            return rangeTextComponent;
        }
    }

    private static enum WeightDecoratorType {
        FULL(Set.of(Integer.valueOf(340))),
        OVERALL(Set.of());

        private final Set<Integer> keyCodes;

        private WeightDecoratorType(Set<Integer> keyCodes) {
            this.keyCodes = keyCodes;
        }

        public static WeightDecoratorType getCurrentType() {
            for (WeightDecoratorType type : WeightDecoratorType.values()) {
                if (!type.keyCodes.stream().allMatch(KeyboardUtils::isKeyDown)) continue;
                return type;
            }
            return OVERALL;
        }
    }

    private class SimpleWeightDecorator
    extends WeightingDecorator {
        private SimpleWeightDecorator() {
        }

        @Override
        protected List<class_5250> getWeightLines(ItemWeighting weighting, IdentifiableItemProperty<?, ?> itemInfo) {
            class_5250 weightingComponent = class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43470((String)(weighting.weightName() + " Scale"))).method_27692(class_124.field_1080);
            float percentage = Services.ItemWeight.calculateWeighting(weighting, itemInfo);
            weightingComponent.method_10852((class_2561)ColorScaleUtils.getPercentageTextComponent(ItemStatInfoFeature.this.getColorMap(), percentage, (Boolean)ItemStatInfoFeature.this.colorLerp.get(), (Integer)ItemStatInfoFeature.this.decimalPlaces.get()));
            return List.of(weightingComponent);
        }
    }

    private class FullWeightDecorator
    extends WeightingDecorator {
        private FullWeightDecorator() {
        }

        @Override
        protected List<class_5250> getWeightLines(ItemWeighting weighting, IdentifiableItemProperty<?, ?> itemInfo) {
            ArrayList<class_5250> lines = new ArrayList<class_5250>();
            class_5250 weightingComponent = class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43470((String)(weighting.weightName() + " Scale"))).method_27692(class_124.field_1080);
            float percentage = Services.ItemWeight.calculateWeighting(weighting, itemInfo);
            weightingComponent.method_10852((class_2561)ColorScaleUtils.getPercentageTextComponent(ItemStatInfoFeature.this.getColorMap(), percentage, (Boolean)ItemStatInfoFeature.this.colorLerp.get(), (Integer)ItemStatInfoFeature.this.decimalPlaces.get()));
            lines.add(weightingComponent);
            Map<StatType, Pair<Float, Float>> statWeights = Services.ItemWeight.getStatWeights(weighting, itemInfo);
            statWeights.forEach((statType, weight) -> {
                String displayName = statType.getDisplayName() + " ";
                if (statType.getUnit() == StatUnit.RAW) {
                    displayName = displayName + "Raw ";
                }
                String weightStr = String.format(Locale.ROOT, "(%.1f%%)", weight.a());
                lines.add(class_2561.method_43470((String)"   - ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)displayName)).method_10852((class_2561)class_2561.method_43470((String)weightStr).method_27692(class_124.field_1068)).method_10852((class_2561)ColorScaleUtils.getPercentageTextComponent(ItemStatInfoFeature.this.getColorMap(), ((Float)weight.b()).floatValue(), (Boolean)ItemStatInfoFeature.this.colorLerp.get(), (Integer)ItemStatInfoFeature.this.decimalPlaces.get())));
            });
            return lines;
        }
    }

    public static enum ColorThreshold {
        NINETY_FIVE(95.0f),
        NINETY_SIX(96.0f);

        private final float threshold;

        private ColorThreshold(float threshold) {
            this.threshold = threshold;
        }

        public float getThreshold() {
            return this.threshold;
        }
    }

    private static abstract class WeightingDecorator
    implements TooltipWeightDecorator {
        private WeightingDecorator() {
        }

        @Override
        public List<class_5250> getLines(ItemWeighting weighting, IdentifiableItemProperty<?, ?> itemInfo) {
            return this.getWeightLines(weighting, itemInfo);
        }

        protected abstract List<class_5250> getWeightLines(ItemWeighting var1, IdentifiableItemProperty<?, ?> var2);
    }

    private static abstract class IdentificationDecorator
    implements TooltipIdentificationDecorator {
        private IdentificationDecorator() {
        }

        @Override
        public class_5250 getSuffix(StatActualValue statActualValue, StatPossibleValues possibleValues, TooltipStyle style) {
            if (!possibleValues.range().inRange(statActualValue.value())) {
                return class_2561.method_43470((String)" [NEW]").method_27692(class_124.field_1065);
            }
            return this.getRollSuffix(style, statActualValue, possibleValues);
        }

        protected abstract class_5250 getRollSuffix(TooltipStyle var1, StatActualValue var2, StatPossibleValues var3);
    }
}

