/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.CraftingStationContainer;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.containers.type.HighlightableProfessionProperty;
import com.wynntils.models.items.properties.ProfessionItemProperty;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class ProfessionHighlightFeature
extends Feature {
    @Persisted
    private final Config<CustomColor> highlightColor = new Config<CustomColor>(new CustomColor(20, 89, 204));
    @Persisted
    private final Config<HighlightSelectionMode> selectionMode = new Config<HighlightSelectionMode>(HighlightSelectionMode.PER_CONTAINER);
    @Persisted
    private final Storage<ProfessionType> selectedProfession = new Storage<Object>(null);
    @Persisted
    private final Storage<Map<String, ProfessionType>> selectionPerContainer = new Storage(new TreeMap());

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        Container container;
        class_437 screen = event.getScreen();
        if (!(screen instanceof class_465)) {
            return;
        }
        class_465 containerScreen = (class_465)screen;
        if (!(Models.Container.getCurrentContainer() instanceof HighlightableProfessionProperty)) {
            return;
        }
        if (this.selectedProfession.get() != null && this.selectionMode.get() == HighlightSelectionMode.GLOBAL && (container = Models.Container.getCurrentContainer()) instanceof CraftingStationContainer) {
            CraftingStationContainer craftingStation = (CraftingStationContainer)container;
            this.setSelectedProfession(craftingStation.getProfessionType());
        }
        int renderX = (screen.field_22789 - containerScreen.field_2792) / 2;
        int renderY = (screen.field_22790 - containerScreen.field_2779) / 2;
        this.addWidgets(containerScreen, renderX, renderY);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderSlot(SlotRenderEvent.Pre event) {
        class_437 screen = event.getScreen();
        if (!(screen instanceof class_465)) {
            return;
        }
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof HighlightableProfessionProperty)) {
            return;
        }
        HighlightableProfessionProperty highlightableProfessionProperty = (HighlightableProfessionProperty)((Object)container);
        class_1735 slot = event.getSlot();
        if (!highlightableProfessionProperty.getBounds().getSlots().contains(slot.field_7874)) {
            return;
        }
        Optional<ProfessionItemProperty> professionItemPropertyOpt = Models.Item.asWynnItemProperty(slot.method_7677(), ProfessionItemProperty.class);
        if (professionItemPropertyOpt.isEmpty()) {
            return;
        }
        ProfessionType selectedProfession = this.getSelectedProfession();
        if (selectedProfession == null) {
            return;
        }
        if (!professionItemPropertyOpt.get().getProfessionTypes().contains(selectedProfession)) {
            return;
        }
        RenderSystem.enableDepthTest();
        RenderUtils.drawTexturedRectWithColor(event.getPoseStack(), Texture.HIGHLIGHT.resource(), (CustomColor)this.highlightColor.get(), slot.field_7873 - 1, slot.field_7872 - 1, 201.0f, 18.0f, 18.0f, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
        RenderSystem.disableDepthTest();
    }

    private void setSelectedProfession(ProfessionType professionType) {
        if (this.selectionMode.get() == HighlightSelectionMode.GLOBAL) {
            this.selectedProfession.store(professionType);
            return;
        }
        Container currentContainer = Models.Container.getCurrentContainer();
        if (currentContainer == null) {
            return;
        }
        Map containerSelection = (Map)this.selectionPerContainer.get();
        containerSelection.put(currentContainer.getContainerName(), professionType);
        this.selectionPerContainer.touched();
    }

    private ProfessionType getSelectedProfession() {
        if (this.selectionMode.get() == HighlightSelectionMode.GLOBAL) {
            return (ProfessionType)this.selectedProfession.get();
        }
        Container currentContainer = Models.Container.getCurrentContainer();
        if (currentContainer == null) {
            return null;
        }
        Map containerSelection = (Map)this.selectionPerContainer.get();
        return (ProfessionType)containerSelection.get(currentContainer.getContainerName());
    }

    private void addWidgets(class_465<?> containerScreen, int renderX, int renderY) {
        renderX += containerScreen.field_2792 + 2;
        if (Models.Container.getCurrentContainer() instanceof PersonalStorageContainer) {
            renderX += 10;
        }
        containerScreen.method_37063((class_364)new ProfessionHighlightButton(renderX, renderY, 20, 20));
    }

    private static enum HighlightSelectionMode {
        PER_CONTAINER,
        GLOBAL;

    }

    private static final class ProfessionHighlightButton
    extends WynntilsButton {
        private ProfessionHighlightButton(int x, int y, int width, int height) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
        }

        public class_2561 method_25369() {
            ProfessionHighlightFeature feature = Managers.Feature.getFeatureInstance(ProfessionHighlightFeature.class);
            ProfessionType profession = feature.getSelectedProfession();
            if (profession == null) {
                return class_2561.method_43470((String)"-");
            }
            return class_2561.method_43470((String)profession.getProfessionIconChar());
        }

        public void method_25365(boolean focused) {
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!this.method_25405(mouseX, mouseY)) {
                return false;
            }
            ProfessionHighlightFeature feature = Managers.Feature.getFeatureInstance(ProfessionHighlightFeature.class);
            if (KeyboardUtils.isShiftDown()) {
                feature.setSelectedProfession(null);
                return true;
            }
            Object profession = feature.getSelectedProfession();
            Container container = Models.Container.getCurrentContainer();
            if (container instanceof CraftingStationContainer) {
                CraftingStationContainer craftingStation = (CraftingStationContainer)container;
                profession = profession == null ? craftingStation.getProfessionType() : null;
                feature.setSelectedProfession((ProfessionType)profession);
                return true;
            }
            if (button == 0) {
                int nextIndex;
                profession = profession == null ? ProfessionType.craftingProfessionTypes().getFirst() : ((nextIndex = (ProfessionType.craftingProfessionTypes().indexOf(profession) + 1) % ProfessionType.craftingProfessionTypes().size()) == 0 ? null : ProfessionType.craftingProfessionTypes().get(nextIndex));
                feature.setSelectedProfession((ProfessionType)profession);
                return true;
            }
            if (button == 1) {
                int nextIndex;
                profession = profession == null ? ProfessionType.craftingProfessionTypes().getLast() : ((nextIndex = (ProfessionType.craftingProfessionTypes().indexOf(profession) - 1) % ProfessionType.craftingProfessionTypes().size()) == -1 ? null : ProfessionType.craftingProfessionTypes().get(nextIndex));
                feature.setSelectedProfession((ProfessionType)profession);
                return true;
            }
            return false;
        }

        public void method_25306() {
        }
    }
}

