/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.mod.event.WynncraftConnectionEvent;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.mc.event.TitleScreenInitEvent;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_7172;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UTILITIES)
public class SilencerFeature
extends Feature {
    @Persisted
    private final Config<Double> silencerVolume = new Config<Double>(0.01);
    @RegisterKeyBind
    private final KeyBind silencerKeyBind = new KeyBind("Toggle Silencer", -1, true, this::toggleSilencer);
    @Persisted
    private final Storage<Double> originalVolume = new Storage<Double>(1.0);
    private boolean isSilencerEnabled = false;
    private boolean firstTitleScreenInit = true;

    @SubscribeEvent
    public void onDisconnect(WynncraftConnectionEvent.Disconnected event) {
        if (this.isSilencerEnabled) {
            this.restoreOriginalVolume();
            this.isSilencerEnabled = false;
        }
    }

    @SubscribeEvent
    public void onTitleScreenInit(TitleScreenInitEvent.Pre event) {
        if (!this.firstTitleScreenInit) {
            return;
        }
        if (!((Double)this.masterVolume().method_41753()).equals(this.silencerVolume.get())) {
            return;
        }
        this.restoreOriginalVolume();
        this.firstTitleScreenInit = false;
    }

    private void toggleSilencer() {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        boolean bl = this.isSilencerEnabled = !this.isSilencerEnabled;
        if (this.isSilencerEnabled) {
            this.enableSilencer();
            Managers.Notification.queueMessage((class_2561)class_2561.method_43471((String)"feature.wynntils.silencer.enabled").method_27692(class_124.field_1060));
        } else {
            this.restoreOriginalVolume();
            Managers.Notification.queueMessage((class_2561)class_2561.method_43471((String)"feature.wynntils.silencer.disabled").method_27692(class_124.field_1061));
        }
    }

    private void restoreOriginalVolume() {
        this.masterVolume().method_41748((Object)((Double)this.originalVolume.get()));
    }

    private void enableSilencer() {
        this.originalVolume.store((Double)this.masterVolume().method_41753());
        this.masterVolume().method_41748((Object)((Double)this.silencerVolume.get()));
    }

    private class_7172<Double> masterVolume() {
        return McUtils.options().method_45578(class_3419.field_15250);
    }
}

