/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.wynntils;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.services.athena.type.UpdateResult;
import com.wynntils.utils.mc.McUtils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.WYNNTILS)
public class UpdatesFeature
extends Feature {
    @Persisted
    private final Config<Boolean> updateReminder = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> autoUpdate = new Config<Boolean>(false);

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (!event.isFirstJoinWorld()) {
            return;
        }
        if (!Services.Update.shouldPromptUpdate()) {
            return;
        }
        CompletableFuture.runAsync(() -> Services.Update.getLatestBuild().whenCompleteAsync((updateInfo, throwable) -> Managers.TickScheduler.scheduleNextTick(() -> {
            if (updateInfo == null) {
                WynntilsMod.info("Couldn't fetch latest version, not attempting update reminder or auto-update.");
                return;
            }
            Services.Update.setHasPromptedUpdate(true);
            if (((Boolean)this.updateReminder.get()).booleanValue()) {
                if (WynntilsMod.isDevelopmentEnvironment()) {
                    WynntilsMod.info("Tried to show update reminder, but we are in development environment.");
                    return;
                }
                UpdatesFeature.remindToUpdateIfExists(updateInfo.version());
            }
            if (((Boolean)this.autoUpdate.get()).booleanValue()) {
                if (WynntilsMod.isDevelopmentEnvironment()) {
                    WynntilsMod.info("Tried to auto-update, but we are in development environment.");
                    return;
                }
                WynntilsMod.info("Attempting to auto-update.");
                McUtils.sendMessageToClient((class_2561)class_2561.method_43471((String)"feature.wynntils.updates.updating").method_27692(class_124.field_1054));
                CompletableFuture<UpdateResult> completableFuture = Services.Update.tryUpdate();
                completableFuture.whenCompleteAsync((result, t) -> McUtils.sendMessageToClient((class_2561)result.getMessage()));
            }
        })));
    }

    private static void remindToUpdateIfExists(String newVersion) {
        class_5250 clickable = class_2561.method_43471((String)"feature.wynntils.updates.reminder.clickable");
        clickable.method_10862(clickable.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, "/wynntils update")).method_30938(Boolean.valueOf(true)).method_10982(Boolean.valueOf(true)));
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)"[Wynntils]: ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43469((String)"feature.wynntils.updates.reminder", (Object[])new Object[]{WynntilsMod.getVersion(), newVersion}).method_10852((class_2561)clickable).method_27692(class_124.field_1060)));
    }
}

