/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.models.abilities.AbilityModel;
import com.wynntils.models.character.type.VehicleType;
import com.wynntils.models.objectives.WynnObjective;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.NamedValue;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_746;

public class CharacterFunctions {

    public static class AspectTierFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            String aspectName = arguments.getArgument("aspectName").getStringValue();
            return Models.Aspect.getAspectTierByName(aspectName).orElse(0);
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("aspectName", String.class, null)));
        }
    }

    public static class IsAspectEquippedFunction
    extends Function<Boolean> {
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            String aspectName = arguments.getArgument("aspectName").getStringValue();
            return Models.Aspect.getEquippedAspectByName(aspectName).isPresent();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("aspectName", String.class, null)));
        }
    }

    public static class EquippedAspectFunction
    extends Function<NamedValue> {
        @Override
        public NamedValue getValue(FunctionArguments arguments) {
            int aspectIndex = arguments.getArgument("index").getIntegerValue();
            Optional<String> equippedAspectOpt = Models.Aspect.getEquippedAspect(aspectIndex);
            if (equippedAspectOpt.isEmpty()) {
                return NamedValue.EMPTY;
            }
            Optional<Integer> aspectTierOpt = Models.Aspect.getAspectTierByName(equippedAspectOpt.get());
            return aspectTierOpt.map(s -> new NamedValue((String)equippedAspectOpt.get(), ((Integer)aspectTierOpt.get()).intValue())).orElse(NamedValue.EMPTY);
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("index", Integer.class, null)));
        }
    }

    public static class PersonalObjectiveGoalFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            int index = arguments.getArgument("index").getIntegerValue();
            List<WynnObjective> daily = Models.Objectives.getPersonalObjectives();
            return !daily.isEmpty() && index >= 0 && daily.size() > index ? daily.get(index).getGoal() : "";
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<Integer>("index", Integer.class, 0)));
        }
    }

    public static class PersonalObjectiveScoreFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            int index = arguments.getArgument("index").getIntegerValue();
            List<WynnObjective> daily = Models.Objectives.getPersonalObjectives();
            return !daily.isEmpty() && index >= 0 && daily.size() > index ? daily.get(index).getScore() : CappedValue.EMPTY;
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<Integer>("index", Integer.class, 0)));
        }
    }

    public static class GuildObjectiveGoalFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            WynnObjective weekly = Models.Objectives.getGuildObjective();
            if (weekly == null) {
                return "";
            }
            return weekly.getGoal();
        }
    }

    public static class GuildObjectiveScoreFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            WynnObjective weekly = Models.Objectives.getGuildObjective();
            if (weekly == null) {
                return CappedValue.EMPTY;
            }
            return weekly.getScore();
        }
    }

    public static class OphanimHealingPercentFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return AbilityModel.ophanimBar.isActive() ? AbilityModel.ophanimBar.getHealed() : -1;
        }
    }

    public static class HummingbirdsStateFunction
    extends Function<Boolean> {
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            return Models.Ability.hummingBirdsState;
        }
    }

    public static class HasNoGuiFunction
    extends Function<Boolean> {
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            return Models.Character.getVehicle() == VehicleType.DISPLAY;
        }
    }

    public static class IsRidingHorseFunction
    extends Function<Boolean> {
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            return Models.Character.getVehicle() == VehicleType.HORSE;
        }
    }

    public static class CommanderActivatedFunction
    extends Function<Boolean> {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            boolean bl;
            if (AbilityModel.commanderBar.isActive()) {
                if (AbilityModel.commanderBar.isActivated()) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        }
    }

    public static class CommanderDurationFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return AbilityModel.commanderBar.isActive() ? AbilityModel.commanderBar.getDuration() : 0;
        }
    }

    public static class CappedHolyPowerFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return AbilityModel.holyPowerBar.isActive() ? AbilityModel.holyPowerBar.getBarProgress().value() : CappedValue.EMPTY;
        }

        @Override
        protected List<String> getAliases() {
            return List.of("capped_sacred_surge");
        }
    }

    public static class OphanimActive
    extends Function<Boolean> {
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            return AbilityModel.ophanimBar.isActive();
        }
    }

    public static class OphanimOrb
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            int orbNumber = arguments.getArgument("orbNumber").getIntegerValue();
            return orbNumber < AbilityModel.ophanimBar.getOrbs().size() && orbNumber >= 0 ? AbilityModel.ophanimBar.getOrbs().get(orbNumber).getHealthState() : -1;
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("orbNumber", Integer.class, null)));
        }
    }

    public static class CappedOphanimFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return AbilityModel.ophanimBar.isActive() ? AbilityModel.ophanimBar.getBarProgress().value() : CappedValue.EMPTY;
        }
    }

    public static class CappedManaBankFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return AbilityModel.manaBankBar.isActive() ? AbilityModel.manaBankBar.getBarProgress().value() : CappedValue.EMPTY;
        }
    }

    public static class CappedFocusFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return AbilityModel.focusBar.isActive() ? AbilityModel.focusBar.getBarProgress().value() : CappedValue.EMPTY;
        }
    }

    public static class CappedCorruptedFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return AbilityModel.corruptedBar.isActive() ? AbilityModel.corruptedBar.getBarProgress().value() : CappedValue.EMPTY;
        }
    }

    public static class CappedBloodPoolFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return AbilityModel.bloodPoolBar.isActive() ? AbilityModel.bloodPoolBar.getBarProgress().value() : CappedValue.EMPTY;
        }
    }

    public static class CappedAwakenedProgressFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return AbilityModel.awakenedBar.isActive() ? AbilityModel.awakenedBar.getBarProgress().value() : CappedValue.EMPTY;
        }
    }

    public static class IdFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            return Models.Character.getId();
        }
    }

    public static class ManaPctFunction
    extends Function<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getMana().orElse(CappedValue.EMPTY).getPercentage();
        }
    }

    public static class HealthPctFunction
    extends Function<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getHealth().orElse(CappedValue.EMPTY).getPercentage();
        }
    }

    public static class HealthMaxFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getHealth().orElse(CappedValue.EMPTY).max();
        }
    }

    public static class HealthFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getHealth().orElse(CappedValue.EMPTY).current();
        }
    }

    public static class ManaMaxFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getMana().orElse(CappedValue.EMPTY).max();
        }
    }

    public static class ManaFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getMana().orElse(CappedValue.EMPTY).current();
        }
    }

    public static class ClassFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            String name;
            Boolean showReskinnedName = arguments.getArgument("showReskinnedName").getBooleanValue();
            String string = name = showReskinnedName != false ? Models.Character.getActualName() : Models.Character.getClassType().getActualName(false);
            if (arguments.getArgument("uppercase").getBooleanValue().booleanValue()) {
                return name.toUpperCase(Locale.ROOT);
            }
            return name;
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<Boolean>("uppercase", Boolean.class, false), new Argument<Boolean>("showReskinnedName", Boolean.class, true)));
        }
    }

    public static class BpsXzFunction
    extends Function<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            class_746 player = McUtils.player();
            double dX = player.method_23317() - player.field_6038;
            double dZ = player.method_23321() - player.field_5989;
            return Math.sqrt(dX * dX + dZ * dZ) * 20.0;
        }
    }

    public static class BpsFunction
    extends Function<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            class_746 player = McUtils.player();
            double dX = player.method_23317() - player.field_6038;
            double dZ = player.method_23321() - player.field_5989;
            double dY = player.method_23318() - player.field_5971;
            return Math.sqrt(dX * dX + dZ * dZ + dY * dY) * 20.0;
        }
    }

    public static class SprintFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getSprint().orElse(CappedValue.EMPTY);
        }
    }

    public static class CappedHealthFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getHealth().orElse(CappedValue.EMPTY);
        }
    }

    public static class CappedManaFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            return Models.CharacterStats.getMana().orElse(CappedValue.EMPTY);
        }
    }
}

