/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions;

import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.services.statistics.type.StatisticEntry;
import com.wynntils.services.statistics.type.StatisticKind;
import com.wynntils.utils.type.Time;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;

public final class StatisticFunctions {

    private static abstract class StatisticFunction<T>
    extends Function<T> {
        protected static final long DEFAULT_VALUE = -1L;

        private StatisticFunction() {
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("statisticKey", String.class, null), new Argument<Object>("overall", Boolean.class, null)));
        }

        @Override
        public String getArgumentDescription(String argumentName) {
            if (Objects.equals(argumentName, "statisticKey")) {
                return class_1074.method_4662((String)"function.wynntils.statistics.argument.statisticKey", (Object[])new Object[0]);
            }
            if (Objects.equals(argumentName, "overall")) {
                return class_1074.method_4662((String)"function.wynntils.statistics.argument.overall", (Object[])new Object[0]);
            }
            return super.getArgumentDescription(argumentName);
        }

        protected static StatisticEntry getStatisticEntry(FunctionArguments arguments) {
            String statisticKey = arguments.getArgument("statisticKey").getStringValue();
            boolean overall = arguments.getArgument("overall").getBooleanValue();
            StatisticKind statisticKind = StatisticKind.from(statisticKey);
            if (statisticKind == null) {
                return null;
            }
            StatisticEntry statistic = overall ? Services.Statistics.getOverallStatistic(statisticKind) : Services.Statistics.getStatistic(statisticKind);
            return statistic;
        }
    }

    public static class StatisticsFormattedFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            String statisticKey = arguments.getArgument("statisticKey").getStringValue();
            int value = arguments.getArgument("value").getIntegerValue();
            StatisticKind statisticKind = StatisticKind.from(statisticKey);
            if (statisticKind == null) {
                return "-";
            }
            return statisticKind.getFormattedValue(value);
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("statisticKey", String.class, null), new Argument<Object>("value", Number.class, null)));
        }
    }

    public static class StatisticsLastModifiedFunction
    extends StatisticFunction<Long> {
        @Override
        public Long getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsLastModifiedFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return 0L;
            }
            return statistic.lastModified();
        }
    }

    public static class StatisticsLastModifiedTimeFunction
    extends StatisticFunction<Time> {
        @Override
        public Time getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsLastModifiedTimeFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return Time.NONE;
            }
            return Time.of(statistic.lastModified());
        }
    }

    public static class StatisticsFirstModifiedFunction
    extends StatisticFunction<Long> {
        @Override
        public Long getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsFirstModifiedFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return 0L;
            }
            return statistic.firstModified();
        }
    }

    public static class StatisticsFirstModifiedTimeFunction
    extends StatisticFunction<Time> {
        @Override
        public Time getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsFirstModifiedTimeFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return Time.NONE;
            }
            return Time.of(statistic.firstModified());
        }
    }

    public static class StatisticsAverageFunction
    extends StatisticFunction<Long> {
        @Override
        public Long getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsAverageFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return -1L;
            }
            return statistic.average();
        }
    }

    public static class StatisticsMaxFunction
    extends StatisticFunction<Long> {
        @Override
        public Long getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsMaxFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return -1L;
            }
            return statistic.max();
        }
    }

    public static class StatisticsMinFunction
    extends StatisticFunction<Long> {
        @Override
        public Long getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsMinFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return -1L;
            }
            return statistic.min();
        }
    }

    public static class StatisticsCountFunction
    extends StatisticFunction<Long> {
        @Override
        public Long getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsCountFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return -1L;
            }
            return statistic.count();
        }
    }

    public static class StatisticsTotalFunction
    extends StatisticFunction<Long> {
        @Override
        public Long getValue(FunctionArguments arguments) {
            StatisticEntry statistic = StatisticsTotalFunction.getStatisticEntry(arguments);
            if (statistic == null) {
                return -1L;
            }
            return statistic.total();
        }
    }
}

