/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.protocol.io;

import com.wynntils.hades.utils.HadesBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.zip.Deflater;

public class HadesCompressionEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final HadesBuffer buffer = new HadesBuffer();
    private final byte[] byteBuffer = new byte[8192];
    private final Deflater deflater = new Deflater();
    private final int threshold;

    public HadesCompressionEncoder(int threshold) {
        this.threshold = threshold;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int messageSize = msg.readableBytes();
        this.buffer.setBuffer(out);
        if (messageSize < this.threshold) {
            this.buffer.writeVarInt(0);
            this.buffer.writeBytes(msg);
            return;
        }
        byte[] toCompress = new byte[messageSize];
        msg.readBytes(toCompress);
        this.buffer.writeVarInt(toCompress.length);
        this.deflater.setInput(toCompress, 0, messageSize);
        this.deflater.finish();
        while (!this.deflater.finished()) {
            int hold = this.deflater.deflate(this.byteBuffer);
            this.buffer.writeBytes(this.byteBuffer, 0, hold);
        }
        this.deflater.reset();
    }
}

